<?php
/**
 * Klasa z akcjami do zakłądek wykorzystwanych np. w admin generatorze.
 *
 */
class artTabActions extends artActions
{

    /**
     * Konstruktor.
     *
     * @param $context
     * @param $moduleName
     * @param $actionName
     */
    public function __construct($context, $moduleName, $actionName)
    {
        parent::__construct($context, $moduleName, $actionName);

        $this->tabsConfiguration = $this->getConfiguration($moduleName);

        if (!(sfContext::getInstance()->getController() instanceof artFrontWebController))
            throw new sfException('Klasa kontrolera powinna być klasą artFrontWebController lub dziedziczącą po niej!.
        Możesz to zmienić w factories.yml.');

        if (!in_array('ArteneoPartial', sfConfig::get('sf_standard_helpers')))
            throw new sfException('Zamiast PartialHelper, załaduj ArteneoPartialHelper - zrób to w settings.yml');

        if (!method_exists($this, 'setForeignKeysValues'))
            throw new sfException('Stwórz metodę setForeignKeysValues(sfWebRequest $request).
        Musi ona zwracać tablicę.');
    }

    /**
     * Pobiera zakąłdki formularza.
     *
     * @param sfWebRequest $request
     * @return string
     */
    public function executeGetTabsForm(sfWebRequest $request)
    {
        $this->tabName = $request->getParameter('tab_name');

        //uruchom metodę przed zrobieniem czegokolwiek w akcji
        $this->runMethodIfExists('preTabsAction' . $this->tabName);

        $methodName = 'getTabsForm' . $this->tabName;

        if (method_exists($this, $methodName))
            return $this->$methodName($request);

        if (!($request->isMethod('post') && $request->isXmlHttpRequest()))
            return sfView::NONE;

        //sprawdzenie, czy klucze obce zwalidowały się poprawnie,
        //jeżeli nie, to koniec akcji
        if (!$this->runTabMethodIfExists('validateForeignKeys'))
            return sfView::NONE;

        //uruchom metodę przed stworzeniem obiektu formularza
        $this->runMethodIfExists('preGetTabsForm' . $this->tabName);

        //metoda tworzenia formularza. Próba odpalenia metody tworzenia formularza dla danej zakładki
        $this->runTabMethodIfExists('createTabsForm');

        //uruchom metodę po stworzeniu obiektu formularza
        $this->runMethodIfExists('postGetTabsForm' . $this->tabName);

        //metoda obsługi formularza. Próba odpalenia metody obsługi formularza dla danej zakładki
        $processPartial = $this->runTabMethodIfExists('processTabsForm', array($request));

        $partial = $this->renderPartialFromArray($partialsArray = array(
            $this->getModuleName() . '/get_tab_form_' . $this->tabName,
            $this->getModuleName() . '/get_tab_form',
            'tabs_form/get_tab_form'
        ));

        //uruchom metodę po wykonaniu całej akcji
        $this->runMethodIfExists('postTabsAction' . $this->tabName);

        if (isset($processPartial) && $processPartial !== false)
            return $this->renderText($processPartial);

        if ($partial !== false)
            return $this->renderText($partial);
    }

    /**
     * Metoda tworzenia formularza.
     *
     * @param sfWebRequest $request
     */
    public function createTabsForm()
    {
        $this->formClass = $this->tabsConfiguration->getFormClass();
        $doctrineObjectClass = $this->tabsConfiguration->getDoctrineObjectClass();
        $this->doctrineObjectClass = $doctrineObjectClass;

        if ($doctrineObjectClass != '')
            $this->doctrineObject = new $doctrineObjectClass();

        //jeżeli istnieje dla danej zakładki obiekt formularza
        if (!is_null($this->formClass)) {
            //jezeli nie istnieje w requescie klucz do danej zakładki, to stwórz pusty obiekt formularza
            if (!$this->tabsConfiguration->issetForeignKeyForTabInRequest() || $doctrineObjectClass == '')
                $this->form = new $this->formClass();
            else {
                $methodName = 'getObjectForTabsForm' . $this->tabName;
                $tableObject = Doctrine::getTable($doctrineObjectClass);

                if (method_exists($tableObject, $methodName))
                    $this->doctrineObject = $tableObject->$methodName($this->tabsConfiguration->getForeignKeys());
                else
                    $this->doctrineObject = $tableObject->find($this->tabsConfiguration->getForeignKeyForTab());

                $this->form = new $this->formClass($this->doctrineObject);
            }
        }
    }

    /**
     * Metoda obsługi formularza
     *
     * @param sfWebRequest $request
     */
    public function processTabsForm($request)
    {
        if (isset($this->form) && $request->isMethod('post') && $request->hasParameter($this->form->getName())) {
            $this->form->bind($request->getParameter($this->form->getName()), $request->getFiles($this->form->getName()));

            if ($this->form->isValid()) {
                $this->formObject = $this->form->save();
                $this->isValid = true;

                if ($this->doctrineObjectClass == '') {
                    $this->foreignKeyValue = $this->runMethodIfExists('getForeignKeyForValidForm' . $this->tabName);

                    if (is_null($this->foreignKeyValue))
                        $this->foreignKeyValue = is_null($this->formObject) ? true : $this->formObject;

                    $this->tabsConfiguration->setForeignKeyForCurrentTab($this->foreignKeyValue);
                } else {
                    $this->foreignKeyValue = $this->runTabMethodIfExists('getForeignKeyForValidForm');
                    $this->tabsConfiguration->setForeignKeyForCurrentTab($this->foreignKeyValue);

                    if ($this->form->isNew())
                        $this->form = new $this->formClass($this->formObject);
                }

                return $this->renderPartialIfExists($this->getModuleName() . '/partial_after_save_' . $this->tabName);
            }
        }

        return false;
    }

    /**
     * Nowy obiekt.
     *
     * @param sfWebRequest $request
     * @return string
     */
    public function executeNew(sfWebRequest $request)
    {
        return 'tabs_form/TabFormSuccess';
    }

    /**
     * Edycja obiektu.
     *
     * @param sfWebRequest $request
     * @return string
     */
    public function executeEdit(sfWebRequest $request)
    {
        $this->tabsConfiguration->setForeignKeys($this->setForeignKeysValues($request));

        return 'tabs_form/TabFormSuccess';
    }

    /**
     * Funkcja uruchamia metodę $methodNameNAZWAZAKŁADKI, jeżeli taka metoda istnieje
     * w przeciwnym wypadku uruchamia metodę $methodName
     *
     * @param string $methodName nazwa metody
     * @param array $arguments parametry wywołania metody
     * @return type zwraca wynik działania metody
     */
    public function runTabMethodIfExists($methodName, $arguments = array())
    {
        if (method_exists($this, $methodName . $this->tabName))
            $methodName .= $this->tabName;

        return call_user_func_array(array($this, $methodName), $arguments);
    }

    /**
     * Metoda walidacji wartości kluczy obcych - najlepiej do nadpisania w klasach dziedziczących
     *
     * @return boolean
     */
    protected function validateForeignKeys()
    {
        return true;
    }

    /**
     * Metoda, która zwraca wartość klucza obcego, wywoływana w momencie poprawnego zwalidowania formularza
     * oraz wykonania metody save() na formularzu.
     * $this->formObject zawiera doctrinowy obiekt, zwrócony poprzez metodę save() formularza
     *
     * @return mixed wartość klucza obcego
     */
    public function getForeignKeyForValidForm()
    {
        return $this->formObject->getId();
    }

    /**
     * Funkcja zwraca obiekt klasy konfiguracji
     *
     * @return BaseTabFormConfiguration obiekt klasy konfiguracji
     */
    protected function getConfiguration()
    {
        $configurationClass = sfInflector::camelize($this->getModuleName()) . 'TabFormConfiguration';
        $pluginConfigurationClass = 'Plugin' . $configurationClass;

        if (class_exists($configurationClass))
            return new $configurationClass($this);
        else if (class_exists($pluginConfigurationClass))
            return new $pluginConfigurationClass($this);
        else
            throw new sfException('Zdefinuj klasę ' . $configurationClass . ' lub ' . $pluginConfigurationClass);
    }
}
