<?php
/**
 * Klasa nadpisuje metody. sfViewConfigHandler.
 *
 *
 */

class artViewConfigHandler extends sfViewConfigHandler
{

  /**
   * Adds stylesheets, javascripts and dynamicJavascripts statements to the data.
   *
   * @param string $viewName The view name
   *
   * @return string The PHP statement
   */
  protected function addHtmlAsset($viewName = '')
  {
    // Merge the current view's stylesheets with the app's default stylesheets
    $stylesheets = $this->mergeConfigValue('stylesheets', $viewName);
    $css = $this->addAssets('Stylesheet', $stylesheets);

    // Merge the current view's javascripts with the app's default javascripts
    $javascripts = $this->mergeConfigValue('javascripts', $viewName);
    $js = $this->addAssets('Javascript', $javascripts);
    
    $dynamicJavascripts = $this->mergeConfigValue('dynamic_javascripts', $viewName);
    $djs = $this->addAssets('DynamicJavascripts', $dynamicJavascripts);

    return implode("\n", array_merge($css, $js, $djs))."\n";
  }
  
  /**
   * Creates a list of add$Type PHP statements for the given type and config.
   *
   * @param string $type of asset. Requires an sfWebResponse->add$Type(string, string, array) method
   *
   * @return array ist of add$Type PHP statements
   */
  private function addAssets($type, $assets){
    $tmp = array();
    foreach ((array) $assets as $asset)
    {
      $position = '';
      if (is_array($asset))
      {
        $key = key($asset);
        $options = $asset[$key];
        if (isset($options['position']))
        {
          $position = $options['position'];
          unset($options['position']);
        }
      }
      else
      {
        $key = $asset;
        $options = array();
      }

      if ('-*' == $key)
      {
        $tmp = array();
      }
      else if ('-' == $key[0])
      {
        unset($tmp[substr($key, 1)]);
      }
      else
      {
        $tmp[$key] = sprintf("  \$response->add%s('%s', '%s', %s);", $type, $key, $position, str_replace("\n", '', var_export($options, true)));
      }
    }
    return array_values($tmp);
  }
}
