<?php
/**
 * Klasa służy do sortowania kolekcji. Wykożystywana w galerii.
 */

class artCollectionSorter
{
    private $field, $order;

    /**
     * Konstruktor.
     *
     * @param $field
     * @param $order
     */
    private function __construct($field, $order)
    {
        $this->field = $field;
        $this->order = $order;
    }

    /**
     * Helper do sortowania.
     *
     * @param $a
     * @param $b
     * @return int
     */
    private function sortHelper($a, $b)
    {
        $val1 = $a->{$this->field};
        $val2 = $b->{$this->field};

        if ($val1 == $val2)
            return 0;

        if ($this->order == 'asc')
            return ($val1 < $val2) ? (-1) : (1);

        return ($val1 > $val2) ? (-1) : (1);
    }

    /**
     * @param Doctrine_Collection $collection
     * @param $field
     * @param $order
     * @return Doctrine_Collection
     */
    static public function sort(Doctrine_Collection $collection, $field, $order)
    {
        $data = $collection->getData();
        $sorter = new artCollectionSorter($field, $order);

        usort($data, array($sorter, 'sortHelper'));

        $collection->setData($data);

        return $collection;
    }
}