<?php
/**
 * Description of artDoctrineQuery
 *
 
 */

class artDoctrineQuery extends Doctrine_Query
{

    public $limitSubqueryIds = array();

    /**
     * @param $name
     * @return Doctrine_Query
     */
    public function setEmptyString($name)
    {
        return $this->set($name, "''");
    }

    /**
     * @param $name
     * @return Doctrine_Query
     */
    public function setCurrentDate($name)
    {
        $date = artDate::today();

        return $this->set($name, "'$date'");
    }

    /**
     * @param $name
     * @return Doctrine_Query
     */
    public function setNull($name)
    {
        return $this->set($name, "NULL");
    }

    /**
     * @return array
     */
    public function getLimitSubqueryIds()
    {
        return $this->limitSubqueryIds;
    }

    /**
     * _buildSqlQueryBase
     * returns the base of the generated sql query
     * On mysql driver special strategy has to be used for DELETE statements
     * (where is this special strategy??)
     * ZMIANA MA NA CELU PRZERZUCENIE ZAWSZE DISCTINCTa NA POCZĄTEK SELECTA
     *
     * @return string       the base of the generated sql query
     */
    protected function _buildSqlQueryBase()
    {
        switch ($this->_type) {
            case self::DELETE:
                $q = 'DELETE FROM ';
                break;
            case self::UPDATE:
                $q = 'UPDATE ';
                break;
            case self::SELECT:
                $distinct = ($this->_sqlParts['distinct']) ? 'DISTINCT ' : '';

                foreach ($this->_sqlParts['select'] as $k => $part) {
                    if (strtolower(substr($part, 0, 8)) == 'distinct') {
                        unset($this->_sqlParts['select'][$k]);
                        array_unshift($this->_sqlParts['select'], $part);
                    }
                }

                $q = 'SELECT ' . $distinct . implode(', ', $this->_sqlParts['select']) . ' FROM ';
                break;
        }

        return $q;
    }

    /**
     * @param bool $limitSubquery
     * @return bool|string
     */
    public function buildSqlQuery($limitSubquery = true)
    {
        // reset the state
        if (!$this->isSubquery()) {
            $this->_queryComponents = array();
            $this->_pendingAggregates = array();
            $this->_aggregateAliasMap = array();
        }

        $this->reset();

        // invoke the preQuery hook
        $this->_preQuery();

        // process the DQL parts => generate the SQL parts.
        // this will also populate the $_queryComponents.
        foreach ($this->_dqlParts as $queryPartName => $queryParts) {
            // If we are parsing FROM clause, we'll need to diff the queryComponents later
            if ($queryPartName == 'from') {
                // Pick queryComponents before processing
                $queryComponentsBefore = $this->getQueryComponents();
            }

            // FIX #1667: _sqlParts are cleaned inside _processDqlQueryPart.
            if ($queryPartName != 'forUpdate') {
                $this->_processDqlQueryPart($queryPartName, $queryParts);
            }

            // We need to define the root alias
            if ($queryPartName == 'from') {
                // Pick queryComponents aftr processing
                $queryComponentsAfter = $this->getQueryComponents();

                // Root alias is the key of difference of query components
                $diffQueryComponents = array_diff_key($queryComponentsAfter, $queryComponentsBefore);
                $this->_rootAlias = key($diffQueryComponents);
            }
        }
        $this->_state = self::STATE_CLEAN;

        // Proceed with the generated SQL
        if (empty($this->_sqlParts['from'])) {
            return false;
        }

        $needsSubQuery = false;
        $subquery = '';
        $map = $this->getRootDeclaration();
        $table = $map['table'];
        $rootAlias = $this->getRootAlias();

        if (!empty($this->_sqlParts['limit']) && $this->_needsSubquery &&
            $table->getAttribute(Doctrine_Core::ATTR_QUERY_LIMIT) == Doctrine_Core::LIMIT_RECORDS
        ) {
            // We do not need a limit-subquery if DISTINCT is used
            // and the selected fields are either from the root component or from a localKey relation (hasOne)
            // (i.e. DQL: SELECT DISTINCT u.id FROM User u LEFT JOIN u.phonenumbers LIMIT 5).
            if (!$this->_sqlParts['distinct']) {
                $this->_isLimitSubqueryUsed = true;
                $needsSubQuery = true;
            } else {
                foreach (array_keys($this->_pendingFields) as $alias) {
                    //no subquery for root fields
                    if ($alias == $this->getRootAlias()) {
                        continue;
                    }

                    //no subquery for ONE relations
                    if (isset($this->_queryComponents[$alias]['relation']) &&
                        $this->_queryComponents[$alias]['relation']->getType() == Doctrine_Relation::ONE
                    ) {
                        continue;
                    }

                    $this->_isLimitSubqueryUsed = true;
                    $needsSubQuery = true;
                }
            }
        }

        $sql = array();

        if (!empty($this->_pendingFields)) {
            foreach ($this->_queryComponents as $alias => $map) {
                $fieldSql = $this->processPendingFields($alias);
                if (!empty($fieldSql)) {
                    $sql[] = $fieldSql;
                }
            }
        }

        if (!empty($sql)) {
            array_unshift($this->_sqlParts['select'], implode(', ', $sql));
        }

        $this->_pendingFields = array();

        // build the basic query
        $q = $this->_buildSqlQueryBase();
        $q .= $this->_buildSqlFromPart();

        if (!empty($this->_sqlParts['set'])) {
            $q .= ' SET ' . implode(', ', $this->_sqlParts['set']);
        }

        $string = $this->getInheritanceCondition($this->getRootAlias());

        // apply inheritance to WHERE part
        if (!empty($string)) {
            if (count($this->_sqlParts['where']) > 0) {
                $this->_sqlParts['where'][] = 'AND';
            }

            if (substr($string, 0, 1) === '(' && substr($string, -1) === ')') {
                $this->_sqlParts['where'][] = $string;
            } else {
                $this->_sqlParts['where'][] = '(' . $string . ')';
            }
        }

        $modifyLimit = true;
        $limitSubquerySql = '';

        if ((!empty($this->_sqlParts['limit']) || !empty($this->_sqlParts['offset'])) && $needsSubQuery && $limitSubquery) {
            $subquery = $this->getLimitSubquery();

            // what about composite keys?
            $idColumnName = $table->getColumnName($table->getIdentifier());

            switch (strtolower($this->_conn->getDriverName())) {
                case 'mysql':
                    $this->useQueryCache(false);

                    // mysql doesn't support LIMIT in subqueries
                    $list = $this->_conn->execute($subquery, $this->_execParams)->fetchAll(Doctrine_Core::FETCH_COLUMN);
                    $list = array_map(array($this->_conn, 'quote'), $list);
                    $this->limitSubqueryIds = $list;
                    $subquery = implode(', ', $list);

                    break;

                case 'pgsql':
                    $subqueryAlias = $this->_conn->quoteIdentifier('doctrine_subquery_alias');

                    // pgsql needs special nested LIMIT subquery
                    $subquery = 'SELECT ' . $subqueryAlias . '.' . $this->_conn->quoteIdentifier($idColumnName)
                        . ' FROM (' . $subquery . ') AS ' . $subqueryAlias;

                    break;
            }

            $field = $this->getSqlTableAlias($rootAlias) . '.' . $idColumnName;

            // FIX #1868: If not ID under MySQL is found to be restricted, restrict pk column for null
            //            (which will lead to a return of 0 items)
            $limitSubquerySql = $this->_conn->quoteIdentifier($field)
                . ((!empty($subquery)) ? ' IN (' . $subquery . ')' : ' IS NULL')
                . ((count($this->_sqlParts['where']) > 0) ? ' AND ' : '');


            $modifyLimit = false;
        }

        // FIX #DC-26: Include limitSubquerySql as major relevance in conditions
        $emptyWhere = empty($this->_sqlParts['where']);

        if (!($emptyWhere && $limitSubquerySql == '')) {
            $where = implode(' ', $this->_sqlParts['where']);
            $where = ($where == '' || (substr($where, 0, 1) === '(' && substr($where, -1) === ')'))
                ? $where : '(' . $where . ')';

            $q .= ' WHERE ' . $limitSubquerySql . $where;
            //   .  (($limitSubquerySql == '' && count($this->_sqlParts['where']) == 1) ? substr($where, 1, -1) : $where);
        }

        // Fix the orderbys so we only have one orderby per value
        foreach ($this->_sqlParts['orderby'] as $k => $orderBy) {
            $e = explode(', ', $orderBy);
            unset($this->_sqlParts['orderby'][$k]);
            foreach ($e as $v) {
                $this->_sqlParts['orderby'][] = $v;
            }
        }

        // Add the default orderBy statements defined in the relationships and table classes
        // Only do this for SELECT queries
        if ($this->_type === self::SELECT) {
            foreach ($this->_queryComponents as $alias => $map) {
                $sqlAlias = $this->getSqlTableAlias($alias);
                if (isset($map['relation'])) {
                    $orderBy = $map['relation']->getOrderByStatement($sqlAlias, true);
                    if ($orderBy == $map['relation']['orderBy']) {
                        if (isset($map['ref'])) {
                            $orderBy = $map['relation']['refTable']->processOrderBy($sqlAlias, $map['relation']['orderBy'], true);
                        } else {
                            $orderBy = null;
                        }
                    }
                } else {
                    $orderBy = $map['table']->getOrderByStatement($sqlAlias, true);
                }

                if ($orderBy) {
                    $e = explode(',', $orderBy);
                    $e = array_map('trim', $e);
                    foreach ($e as $v) {
                        if (!in_array($v, $this->_sqlParts['orderby'])) {
                            $this->_sqlParts['orderby'][] = $v;
                        }
                    }
                }
            }
        }

        $q .= (!empty($this->_sqlParts['groupby'])) ? ' GROUP BY ' . implode(', ', $this->_sqlParts['groupby']) : '';
        $q .= (!empty($this->_sqlParts['having'])) ? ' HAVING ' . implode(' AND ', $this->_sqlParts['having']) : '';
        $q .= (!empty($this->_sqlParts['orderby'])) ? ' ORDER BY ' . implode(', ', $this->_sqlParts['orderby']) : '';

        if ($modifyLimit) {
            $q = $this->_conn->modifyLimitQuery($q, $this->_sqlParts['limit'], $this->_sqlParts['offset'], false, false, $this);
        }

        $q .= $this->_sqlParts['forUpdate'] === true ? ' FOR UPDATE ' : '';

        $this->_sql = $q;

        $this->clear();

        return $q;
    }

    /**
     * @param $alias
     * @param string $suffixTranslation
     * @return Doctrine_Query
     */
    public function leftJoinTranslation($alias, $suffixTranslation = 'trans')
    {
        $culture = sfContext::getInstance()->getUser()->getCulture();
        $aliasTranslation = $alias . $suffixTranslation;

        return $this->leftJoin("$alias.Translation $aliasTranslation WITH $aliasTranslation.lang='$culture'");
    }

}
