<?php
/**
 * Description of artDoctrineTable
 *
 
 */

class artDoctrineTable extends Doctrine_Table
{

    public static $context;

    /**
     *
     * @return sfContext
     */
    public static function getContext()
    {
        if (is_null(artDoctrineTable::$context))
            artDoctrineTable::$context = sfContext::getInstance();

        return artDoctrineTable::$context;
    }

    /**
     * @param sfContext $context
     */
    public static function setContext(sfContext $context)
    {
        artDoctrineTable::$context = $context;
    }

    /**
     * @param $name
     * @return bool
     */
    public function hasI18nColumn($name)
    {
        if (!$this->hasTemplate('Doctrine_Template_I18n'))
            return false;
        else {
            $template = $this->getTemplate('Doctrine_Template_I18n');
            $fields = $template->getOption('fields');

            return in_array($name, $fields);
        }
    }

    /**
     * Pobiera użytkownika.
     *
     * @return sfUser
     */
    public function getUser()
    {
        return self::getContext()->getUser();
    }

    /**
     * Pobiera ID użytkwonika.
     *
     * @param null $userId
     * @return null
     */
    public function getUserId($userId = null)
    {
        if (is_null($userId))
            return $this->getUser()->getId();
        else
            return $userId;
    }

    /**
     * Zprawdza czy uzytkownik jest zalogowany.
     *
     * @return mixed
     */
    public function isUserAuthenticated()
    {
        return $this->getUser()->isAuthenticated();
    }

    /**
     * Pobiera język użytkownika.
     *
     * @return null|string
     */
    public function getUserCulture()
    {
        return $this->getUser()->getCulture();
    }

    /**
     * Pobiera i zwraca request.
     *
     * @return sfRequest
     */
    public function getRequest()
    {
        return self::getContext()->getRequest();
    }

    /**
     * Pobiera parametr z requesta.
     *
     * @param $name
     * @param null $default
     * @return mixed
     */
    public function getRequestParameter($name, $default = null)
    {
        return $this->getRequest()->getParameter($name, $default);
    }

    /**
     * Pobiera atrybut z sesji użytkoniwka.
     *
     * @param $name
     * @param null $default
     * @return mixed
     */
    public function getUserAttribute($name, $default = null)
    {
        return $this->getUser()->getAttribute($name, $default);
    }

    /**
     * Tworzy nowy rekrd.
     *
     * @param $values
     */
    public function insertRecord($values)
    {
        $objectName = $this->getComponentName();
        $object = new $objectName();

        $object->setArray($values);

        $object->save();
    }

    /**
     * Spradza czy kolumna istnieje.
     *
     * @param $name
     * @return bool
     */
    public function hasColumnOrHasI18nColumn($name)
    {
        return ($this->hasI18nColumn($name) || $this->hasColumn($name));
    }

    /**
     * Tworzy query, zapytanie.
     *
     * @param string $alias     name for component aliasing
     * @return artDoctrineQuery
     */
    public function createQuery($alias = '')
    {
        if (!empty($alias))
            $alias = ' ' . trim($alias);

        $class = $this->getAttribute(Doctrine_Core::ATTR_QUERY_CLASS);

        return Doctrine_Query::create(null, $class)
            ->from($this->getComponentName() . $alias);
    }

    /**
     * Pobiera tłumaczenia.
     *
     * @return Doctrine_Query
     */
    public function getTranslationList()
    {
        return $this->createQuery('a')
            ->leftJoinTranslation('a');
    }

}
