<?php
/**
 * Klasa ,używana do szyfrowania danych.
 */

class Encrypted extends Doctrine_Template
{
    protected $_options = array('allowed_types' => array(
        'string',
        'clob'
    ));

    protected $_disabledFields = array();

    /**
     * @param $array
     * @return array
     */
    protected function sortArrayByLength($array)
    {
        if (empty ($array))
            return array();
        $array = array_combine($array, array_map('strlen', $array));
        arsort($array);
        $values = array();
        foreach ($array as $val => $len)
            $values[] = $val;
        return $values;
    }

    /**
     *
     */
    protected function initFields()
    {
        if (isset($this->_options['fields'])) {
            $this->_options['fields'] = $this->sortArrayByLength($this->_options['fields']);
            return;
        }
        $columns = array();
        foreach ($this->getTable()->getColumnNames() as $col) {
            // Pomijamy kolumny id oraz *_id*
            if ($col != 'lang' && $col != 'id' && stripos($col, '_id') === false) {
                $definition = $this->getTable()->getColumnDefinition($col);
                $type = $definition['type'];
                if (in_array($type, $this->_options['allowed_types']))
                    $columns[] = $col;
            }
        }
        $this->_options['fields'] = $this->sortArrayByLength($columns);
    }

    /**
     *
     */
    public function initAesColumns()
    {
        foreach ($this->getTable()->getColumnNames() as $col) {
            if (in_array($col, $this->_options['fields'])) {
                $this->getTable()->setColumnOption($col, 'encrypted', true);
            }
        }
    }

    /**
     *
     */
    public function enableAesColumns()
    {
        foreach ($this->_disabledFields as $col) {
            $this->getTable()->setColumnOption($col, 'encrypted', true);
        }
    }

    /**
     *
     */
    public function disableAesColumns()
    {
        foreach ($this->_options['fields'] as $col) {
            $this->getTable()->setColumnOption($col, 'encrypted', false);
            $this->_disabledFields[] = $col;
            unset($this->_options['fields'][$col]);
        }
    }

    /**
     *
     */
    public function setTableDefinition()
    {
        // Uzupelnia pola do enkrypcji
        $this->initFields();
        // Ustawia wybranym fields opcje 'encrypted' => true
        $this->initAesColumns();
        $this->addListener(new EncryptedListener($this->_options));
    }
}