<?php
/**
 * Klasa ,używana do szyfrowania danych.
 */

class EncryptedListener extends Doctrine_Record_Listener
{

    /**
     * Key used to enrypt/decrypt data. Key must be initialized
     * using initKey().
     * @var string
     */

    protected $key = 'NOKEY';
    /**
     * Array of options
     *
     * @var string
     */
    protected $_options = array();

    /**
     * @param array $options
     */
    public function __construct(array $options)
    {
        $this->_options = $options;
    }

    /**
     * Functions sets key used to encrypt/decrypt to value set in ProjectConfiguration
     */
    protected function initKey()
    {
        $this->key = Doctrine_Manager::getInstance()->getAttribute('encryptedKey');
    }

    /**
     * Encrypts updated columns for object
     * @param Doctrine_Event $event
     */
    public function preUpdate(Doctrine_Event $event)
    {
        $this->initKey();
        foreach ($event->getInvoker()->getTable()->getFieldNames() as $field) {
            if (in_array($field, $this->_options['fields']))
                $event->getInvoker()->set($field, $this->aesEncrypt($event->getInvoker()->get($field)));
        }
    }

    /**
     * Encrypts deleted columns for object
     * @param Doctrine_Event $event
     */
    public function preDelete(Doctrine_Event $event)
    {
        $this->initKey();
        foreach ($event->getInvoker()->getTable()->getFieldNames() as $field) {
            if (in_array($field, $this->_options['fields']))
                $event->getInvoker()->set($field, $this->aesEncrypt($event->getInvoker()->get($field)));
        }
    }

    /**
     * Encrypts inserted columns for object
     * @param Doctrine_Event $event
     */
    public function preInsert(Doctrine_Event $event)
    {
        $this->initKey();
        foreach ($event->getInvoker()->getTable()->getFieldNames() as $field) {
            $def = $event->getInvoker()->getTable()->getColumnDefinition($field);
            if (isset($def['encrypted']) && $def['encrypted'] == true) {
                $event->getInvoker()->set($field, $this->aesEncrypt($event->getInvoker()->get($field)));
            }
        }
    }

    /**
     * Encrypts given string as in MySQL
     * @param string $val
     * @return string
     */
    public function aesEncrypt($val)
    {
        if (is_null($val))
            return $val;

        $val = strtoupper(bin2hex($val));

        if ($this->key == 'NOKEY')
            $this->initKey();

        $ky = $this->key;
        $key = "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
        for ($a = 0; $a < strlen($ky); $a++)
            $key[$a % 16] = chr(ord($key[$a % 16]) ^ ord($ky[$a]));

        $mode = MCRYPT_MODE_ECB;
        $enc = MCRYPT_RIJNDAEL_128;

        $val = str_pad($val, (16 * (floor(strlen($val) / 16) + 1 /*(strlen($val) % 16==0?1:0)*/)), chr(16 - (strlen($val) % 16)));
        $val = mcrypt_encrypt($enc, $key, $val, $mode, mcrypt_create_iv(mcrypt_get_iv_size($enc, $mode), MCRYPT_DEV_URANDOM));
        $val = strtoupper(bin2hex($val));

        return $val;
    }
}
