<?php
/**
 * Klasa służaca do szyfrowania danych, zapisywanych poprzez Doctrine.
 *
 */

class Doctrine_Query_Encrypted extends artDoctrineQuery
{
    const NO_ENCRYPTION = 0;
    const ENCRYPT = 1;
    const DECRYPT = 2;
    protected $key = 'NOKEY';

    /**
     * Two demensional array containing information if certain Dql Part
     * is already encrypted
     * @var array
     */
    protected $_encrypted = array();
    protected $_empty = false;

    /**
     * @param $string
     * @return string
     */
    public function decryptString($string)
    {
        $this->initKey();
        return ' UNHEX(AES_DECRYPT(UNHEX(' . $string . '),\'' . $this->key . '\' ) ) ';
    }

    /**
     * @param $string
     * @return string
     */
    public function encryptString($string)
    {
        $this->initKey();
        return ' HEX( AES_ENCRYPT( HEX(' . $string . ')  , \'' . $this->key . '\' )) ';
    }

    protected function initKey()
    {
        if ($this->key == 'NOKEY')
            $this->key = Doctrine_Manager::getInstance()->getAttribute('encryptedKey');
    }

    public function getKey()
    {
        return $this->key;
    }

    public function getEmpty()
    {
        return $this->_empty;
    }

    public function setEmpty()
    {
        $this->_empty = true;
    }

    public function setEncrypted($part, $offset)
    {
        $this->_encrypted[$part][$offset] = true;
    }

    public function getEncrypted($part, $offset)
    {
        if (isset($this->_encrypted[$part]) && isset($this->_encrypted[$part][$offset]) && $this->_encrypted[$part][$offset] == true) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * _getParser
     * parser lazy-loader
     *
     * @throws Doctrine_Query_Exception     if unknown parser name given
     * @return Doctrine_Query_Part
     * @todo Doc/Description: What is the parameter for? Which parsers are available?
     */
    protected function _getParser($name)
    {
        if (!isset($this->_parsers[$name])) {
            $class = 'Doctrine_Query_Encrypted_' . ucwords(strtolower($name));

            Doctrine_Core::autoload($class);

            if (!class_exists($class)) {
                throw new Doctrine_Query_Exception('Unknown parser ' . $name);
            }

            $this->_parsers[$name] = new $class($this, $this->_tokenizer);
        }

        return $this->_parsers[$name];
    }

    public function parseFunctionExpression($expr, $encrypt = self::NO_ENCRYPTION)
    {
        $pos = strpos($expr, '(');
        $name = substr($expr, 0, $pos);

        if ($name === '') {
            return $this->parseSubquery($expr, $encrypt);
        }

        $argStr = substr($expr, ($pos + 1), -1);
        $args = array();
        // parse args

        foreach ($this->_tokenizer->sqlExplode($argStr, ',') as $arg) {
            $args[] = $this->parseClause($arg, $encrypt);
        }

        // convert DQL function to its RDBMS specific equivalent
        try {
            $expr = call_user_func_array(array($this->_conn->expression, $name), $args);
        } catch (Doctrine_Expression_Exception $e) {
            throw new Doctrine_Query_Exception('Unknown function ' . $name . '.');
        }

        return $expr;
    }


    public function parseSubquery($subquery, $encrypt = self::NO_ENCRYPTION)
    {
        $trimmed = trim($this->_tokenizer->bracketTrim($subquery));

        // check for possible subqueries
        if (substr($trimmed, 0, 4) == 'FROM' || substr($trimmed, 0, 6) == 'SELECT') {
            // parse subquery
            $q = $this->createSubquery()->parseDqlQuery($trimmed);
            $trimmed = $q->getSqlQuery();
            $q->free();
        } else if (substr($trimmed, 0, 4) == 'SQL:') {
            $trimmed = substr($trimmed, 4);
        } else {
            $e = $this->_tokenizer->sqlExplode($trimmed, ',');

            $value = array();
            $index = false;

            foreach ($e as $part) {
                $value[] = $this->parseClause($part, $encrypt);
            }

            $trimmed = implode(', ', $value);
        }

        return '(' . $trimmed . ')';
    }

    /**
     * parseClause
     * parses given DQL clause
     *
     * this method handles five tasks:
     *
     * 1. Converts all DQL functions to their native SQL equivalents
     * 2. Converts all component references to their table alias equivalents
     * 3. Converts all field names to actual column names
     * 4. Quotes all identifiers
     * 5. Parses nested clauses and subqueries recursively
     *
     * @return string   SQL string
     * @todo Description: What is a 'dql clause' (and what not)?
     *       Refactor: Too long & nesting level
     */
    public function parseClause($clause, $encrypt = self::NO_ENCRYPTION, &$fieldEncrypted = false)
    {
        $this->initKey();
        $clause = $this->_conn->dataDict->parseBoolean(trim($clause));

        if (is_numeric($clause)) {
            return $clause;
        }

        $terms = $this->_tokenizer->clauseExplode($clause, array(' ', '+', '-', '*', '/', '<', '>', '=', '>=', '<=', '&', '|'));
        $str = '';

        foreach ($terms as $term) {
            $pos = strpos($term[0], '(');

            if ($pos !== false && substr($term[0], 0, 1) !== "'") {
                $name = substr($term[0], 0, $pos);

                $term[0] = $this->parseFunctionExpression($term[0], $encrypt);
            } else {
                if (substr($term[0], 0, 1) !== "'" && substr($term[0], -1) !== "'") {
                    if (strpos($term[0], '.') !== false) {
                        if (!is_numeric($term[0])) {
                            $e = explode('.', $term[0]);

                            $field = array_pop($e);

                            if ($this->getType() === Doctrine_Query::SELECT) {
                                $componentAlias = implode('.', $e);

                                if (empty($componentAlias)) {
                                    $componentAlias = $this->getRootAlias();
                                }

                                $this->load($componentAlias);

                                // check the existence of the component alias
                                if (!isset($this->_queryComponents[$componentAlias])) {
                                    throw new Doctrine_Query_Exception('Unknown component alias ' . $componentAlias);
                                }

                                $table = $this->_queryComponents[$componentAlias]['table'];

                                $def = $table->getDefinitionOf($field);

                                // get the actual field name from alias
                                $field = $table->getColumnName($field);

                                // check column existence
                                if (!$def) {
                                    throw new Doctrine_Query_Exception('Unknown column ' . $field);
                                }


                                if (isset($def['owner'])) {
                                    $componentAlias = $componentAlias . '.' . $def['owner'];
                                }

                                $tableAlias = $this->getSqlTableAlias($componentAlias);

                                $term[0] = $this->_conn->quoteIdentifier($tableAlias)
                                    . '.'
                                    . $this->_conn->quoteIdentifier($field);

                                if (isset($def['encrypted']) && $def['encrypted'] == true) {
                                    switch ($encrypt) {
                                        case self::NO_ENCRYPTION:
                                            break;
                                        case self::ENCRYPT:
                                            $term[0] = $this->encryptString($term[0]);
                                            break;
                                        case self::DECRYPT:
                                            $term[0] = $this->decryptString($term[0]);
                                            break;
                                    }
                                    $fieldEncrypted = true;
                                }
                            } else {
                                // build sql expression
                                $field = $this->getRoot()->getColumnName($field);
                                $term[0] = $this->_conn->quoteIdentifier($field);
                            }
                        }
                    } else {
                        if (!empty($term[0]) && !in_array(strtoupper($term[0]), self::$_keywords) &&
                            !is_numeric($term[0]) && $term[0] !== '?' && substr($term[0], 0, 1) !== ':'
                        ) {

                            $componentAlias = $this->getRootAlias();

                            $found = false;

                            if ($componentAlias !== false && $componentAlias !== null) {
                                $table = $this->_queryComponents[$componentAlias]['table'];

                                // check column existence
                                if ($table->hasField($term[0])) {
                                    $found = true;

                                    $def = $table->getDefinitionOf($term[0]);

                                    // get the actual column name from field name
                                    $term[0] = $table->getColumnName($term[0]);


                                    if (isset($def['owner'])) {
                                        $componentAlias = $componentAlias . '.' . $def['owner'];
                                    }

                                    $tableAlias = $this->getSqlTableAlias($componentAlias);

                                    if ($this->getType() === Doctrine_Query::SELECT) {
                                        // build sql expression
                                        $term[0] = $this->_conn->quoteIdentifier($tableAlias)
                                            . '.'
                                            . $this->_conn->quoteIdentifier($term[0]);
                                        if (isset($def['encrypted']) && $def['encrypted'] == true) {
                                            switch ($encrypt) {
                                                case self::NO_ENCRYPTION:
                                                    break;
                                                case self::ENCRYPT:
                                                    $term[0] = $this->encryptString($term[0]);
                                                    break;
                                                case self::DECRYPT:
                                                    $term[0] = $this->decryptString($term[0]);
                                                    break;
                                            }
                                            $fieldEncrypted = true;
                                        }
                                    } else {
                                        // build sql expression
                                        $term[0] = $this->_conn->quoteIdentifier($term[0]);
                                    }
                                } else {
                                    $found = false;
                                }
                            }

                            if (!$found) {
                                $term[0] = $this->getSqlAggregateAlias($term[0]);
                            }
                        }
                    }
                }
            }

            $str .= $term[0] . $term[1];
        }
        return $str;
    }

    /**
     * parseSelect
     * parses the query select part and
     * adds selected fields to pendingFields array
     *
     * @param string $dql
     * @todo Description: What information is extracted (and then stored)?
     */
    public function parseSelect($dql)
    {
        $this->initKey();
        $refs = $this->_tokenizer->sqlExplode($dql, ',');

        $pos = strpos(trim($refs[0]), ' ');
        $first = substr($refs[0], 0, $pos);

        // check for DISTINCT keyword
        if ($first === 'DISTINCT') {
            $this->_sqlParts['distinct'] = true;

            $refs[0] = substr($refs[0], ++$pos);
        }

        $parsedComponents = array();

        foreach ($refs as $reference) {
            $reference = trim($reference);

            if (empty($reference)) {
                continue;
            }

            $terms = $this->_tokenizer->sqlExplode($reference, ' ');

            $pos = strpos($terms[0], '(');

            if (count($terms) > 1 || $pos !== false) {
                $expression = array_shift($terms);
                $alias = array_pop($terms);

                if (!$alias) {
                    $alias = substr($expression, 0, $pos);
                }

                // Fix for http://www.doctrine-project.org/jira/browse/DC-706
                if ($pos !== false && substr($expression, 0, 1) !== "'" && substr($expression, 0, $pos) == '') {
                    $_queryComponents = $this->_queryComponents;
                    reset($_queryComponents);
                    $componentAlias = key($_queryComponents);
                } else {
                    $componentAlias = $this->getExpressionOwner($expression);
                }
                $expression = $this->parseClause($expression, Doctrine_Query_Encrypted::DECRYPT);

                $tableAlias = $this->getSqlTableAlias($componentAlias);

                $index = count($this->_aggregateAliasMap);

                $sqlAlias = $this->_conn->quoteIdentifier($tableAlias . '__' . $index);

                $this->_sqlParts['select'][] = $expression . ' AS ' . $sqlAlias;

                $this->_aggregateAliasMap[$alias] = $sqlAlias;
                $this->_expressionMap[$alias][0] = $expression;

                $this->_queryComponents[$componentAlias]['agg'][$index] = $alias;

                $this->_neededTables[] = $tableAlias;

                // Fix for http://www.doctrine-project.org/jira/browse/DC-585
                // Add selected columns to pending fields
                if (preg_match('/^([^\(]+)\.(\'?)(.*?)(\'?)$/', $expression, $field)) {
                    $this->_pendingFields[$componentAlias][$alias] = $field[3];
                }

            } else {
                $e = explode('.', $terms[0]);

                if (isset($e[1])) {
                    $componentAlias = $e[0];
                    $field = $e[1];
                } else {
                    reset($this->_queryComponents);
                    $componentAlias = key($this->_queryComponents);
                    $field = $e[0];
                }

                $this->_pendingFields[$componentAlias][] = $field;
            }
        }
    }

    /**
     * processPendingFields
     * the fields in SELECT clause cannot be parsed until the components
     * in FROM clause are parsed, hence this method is called everytime a
     * specific component is being parsed. For instance, the wildcard '*'
     * is expanded in the list of columns.
     *
     * @throws Doctrine_Query_Exception     if unknown component alias has been given
     * @param string $componentAlias        the alias of the component
     * @return string SQL code
     * @todo Description: What is a 'pending field' (and are there non-pending fields, too)?
     *       What is 'processed'? (Meaning: What information is gathered & stored away)
     */
    public function processPendingFields($componentAlias)
    {
        $this->initKey();

        $tableAlias = $this->getSqlTableAlias($componentAlias);
        $table = $this->_queryComponents[$componentAlias]['table'];

        if (!isset($this->_pendingFields[$componentAlias])) {
            if ($this->_hydrator->getHydrationMode() != Doctrine_Core::HYDRATE_NONE) {
                if (!$this->_isSubquery && $componentAlias == $this->getRootAlias()) {
                    throw new Doctrine_Query_Exception("The root class of the query (alias $componentAlias) "
                        . " must have at least one field selected.");
                }
            }
            return;
        }

        // At this point we know the component is FETCHED (either it's the base class of
        // the query (FROM xyz) or its a "fetch join").

        // Check that the parent join (if there is one), is a "fetch join", too.
        if (!$this->isSubquery() && isset($this->_queryComponents[$componentAlias]['parent'])) {
            $parentAlias = $this->_queryComponents[$componentAlias]['parent'];
            if (is_string($parentAlias) && !isset($this->_pendingFields[$parentAlias])
                && $this->_hydrator->getHydrationMode() != Doctrine_Core::HYDRATE_NONE
                && $this->_hydrator->getHydrationMode() != Doctrine_Core::HYDRATE_SCALAR
                && $this->_hydrator->getHydrationMode() != Doctrine_Core::HYDRATE_SINGLE_SCALAR
            ) {
                throw new Doctrine_Query_Exception("The left side of the join between "
                    . "the aliases '$parentAlias' and '$componentAlias' must have at least"
                    . " the primary key field(s) selected.");
            }
        }

        $fields = $this->_pendingFields[$componentAlias];

        // check for wildcards
        if (in_array('*', $fields)) {
            $fields = $table->getFieldNames();
        } else {
            $driverClassName = $this->_hydrator->getHydratorDriverClassName();
            // only auto-add the primary key fields if this query object is not
            // a subquery of another query object or we're using a child of the Object Graph
            // hydrator
            if (!$this->_isSubquery && is_subclass_of($driverClassName, 'Doctrine_Hydrator_Graph')) {
                $fields = array_unique(array_merge((array)$table->getIdentifier(), $fields));
            }
        }

        $sql = array();
        foreach ($fields as $fieldName) {
            $columnName = $table->getColumnName($fieldName);
            if (($owner = $table->getColumnOwner($columnName)) !== null &&
                $owner !== $table->getComponentName()
            ) {

                $parent = $this->_conn->getTable($owner);
                $columnName = $parent->getColumnName($fieldName);
                $parentAlias = $this->getSqlTableAlias($componentAlias . '.' . $parent->getComponentName());

                $def = $table->getColumnDefinition($columnName);
                $beforeAs = $this->_conn->quoteIdentifier($parentAlias) . '.' . $this->_conn->quoteIdentifier($columnName);
                if (isset($def['encrypted']) && $def['encrypted'] == true)
                    $beforeAs = $this->decryptString($beforeAs);

                $sql[] = $beforeAs
                    . ' AS '
                    . $this->_conn->quoteIdentifier($tableAlias . '__' . $columnName);
            } else {
                $columnName = $table->getColumnName($fieldName);
                $def = $table->getColumnDefinition($columnName);
                $beforeAs = $this->_conn->quoteIdentifier($tableAlias) . '.' . $this->_conn->quoteIdentifier($columnName);
                if (isset($def['encrypted']) && $def['encrypted'] == true)
                    $beforeAs = $this->decryptString($beforeAs);

                $sql[] = $beforeAs
                    . ' AS '
                    . $this->_conn->quoteIdentifier($tableAlias . '__' . $columnName);
            }
        }

        $this->_neededTables[] = $tableAlias;

        return implode(', ', $sql);
    }

    /**
     * @todo Describe & refactor... too long and nested.
     * @param string $path          component alias
     * @param boolean $loadFields
     */
    public function load($path, $loadFields = true)
    {
        if (isset($this->_queryComponents[$path])) {
            return $this->_queryComponents[$path];
        }

        $e = $this->_tokenizer->quoteExplode($path, ' INDEXBY ');

        $mapWith = null;
        if (count($e) > 1) {
            $mapWith = trim($e[1]);

            $path = $e[0];
        }

        // parse custom join conditions
        $e = explode(' ON ', str_ireplace(' on ', ' ON ', $path));

        $joinCondition = '';

        if (count($e) > 1) {
            $joinCondition = substr($path, strlen($e[0]) + 4, strlen($e[1]));
            $path = substr($path, 0, strlen($e[0]));

            $overrideJoin = true;
        } else {
            $e = explode(' WITH ', str_ireplace(' with ', ' WITH ', $path));

            if (count($e) > 1) {
                $joinCondition = substr($path, strlen($e[0]) + 6, strlen($e[1]));
                $path = substr($path, 0, strlen($e[0]));
            }

            $overrideJoin = false;
        }

        $tmp = explode(' ', $path);
        $componentAlias = $originalAlias = (count($tmp) > 1) ? end($tmp) : null;

        $e = preg_split("/[.:]/", $tmp[0], -1);

        $fullPath = $tmp[0];
        $prevPath = '';
        $fullLength = strlen($fullPath);

        if (isset($this->_queryComponents[$e[0]])) {
            $table = $this->_queryComponents[$e[0]]['table'];
            $componentAlias = $e[0];

            $prevPath = $parent = array_shift($e);
        }

        foreach ($e as $key => $name) {
            // get length of the previous path
            $length = strlen($prevPath);

            // build the current component path
            $prevPath = ($prevPath) ? $prevPath . '.' . $name : $name;

            $delimeter = substr($fullPath, $length, 1);

            // if an alias is not given use the current path as an alias identifier
            if (strlen($prevPath) === $fullLength && isset($originalAlias)) {
                $componentAlias = $originalAlias;
            } else {
                $componentAlias = $prevPath;
            }

            // if the current alias already exists, skip it
            if (isset($this->_queryComponents[$componentAlias])) {
                throw new Doctrine_Query_Exception("Duplicate alias '$componentAlias' in query.");
            }

            if (!isset($table)) {
                // process the root of the path

                $table = $this->loadRoot($name, $componentAlias);
            } else {
                $join = ($delimeter == ':') ? 'INNER JOIN ' : 'LEFT JOIN ';

                $relation = $table->getRelation($name);
                $localTable = $table;

                $table = $relation->getTable();
                $this->_queryComponents[$componentAlias] = array('table' => $table,
                    'parent' => $parent,
                    'relation' => $relation,
                    'map' => null);
                if (!$relation->isOneToOne()) {
                    $this->_needsSubquery = true;
                }

                $localAlias = $this->getSqlTableAlias($parent, $localTable->getTableName());
                $foreignAlias = $this->getSqlTableAlias($componentAlias, $relation->getTable()->getTableName());

                $foreignSql = $this->_conn->quoteIdentifier($relation->getTable()->getTableName())
                    . ' '
                    . $this->_conn->quoteIdentifier($foreignAlias);

                $map = $relation->getTable()->inheritanceMap;

                if (!$loadFields || !empty($map) || $joinCondition) {
                    $this->_subqueryAliases[] = $foreignAlias;
                }

                if ($relation instanceof Doctrine_Relation_Association) {
                    $asf = $relation->getAssociationTable();

                    $assocTableName = $asf->getTableName();

                    if (!$loadFields || !empty($map) || $joinCondition) {
                        $this->_subqueryAliases[] = $assocTableName;
                    }

                    $assocPath = $prevPath . '.' . $asf->getComponentName() . ' ' . $componentAlias;

                    $this->_queryComponents[$assocPath] = array(
                        'parent' => $prevPath,
                        'relation' => $relation,
                        'table' => $asf,
                        'ref' => true);

                    $assocAlias = $this->getSqlTableAlias($assocPath, $asf->getTableName());

                    $queryPart = $join
                        . $this->_conn->quoteIdentifier($assocTableName)
                        . ' '
                        . $this->_conn->quoteIdentifier($assocAlias);

                    $queryPart .= ' ON (' . $this->_conn->quoteIdentifier($localAlias
                        . '.'
                        . $localTable->getColumnName($localTable->getIdentifier())) // what about composite keys?
                        . ' = '
                        . $this->_conn->quoteIdentifier($assocAlias . '.' . $relation->getLocalRefColumnName());

                    if ($relation->isEqual()) {
                        // equal nest relation needs additional condition
                        $queryPart .= ' OR '
                            . $this->_conn->quoteIdentifier($localAlias
                                . '.'
                                . $table->getColumnName($table->getIdentifier()))
                            . ' = '
                            . $this->_conn->quoteIdentifier($assocAlias . '.' . $relation->getForeignRefColumnName());
                    }

                    $queryPart .= ')';

                    $this->_sqlParts['from'][] = $queryPart;

                    $queryPart = $join . $foreignSql;

                    if (!$overrideJoin) {
                        $queryPart .= $this->buildAssociativeRelationSql($relation, $assocAlias, $foreignAlias, $localAlias);
                    }
                } else {
                    $queryPart = $this->buildSimpleRelationSql($relation, $foreignAlias, $localAlias, $overrideJoin, $join);
                }

                $queryPart .= $this->buildInheritanceJoinSql($table->getComponentName(), $componentAlias);
                $this->_sqlParts['from'][$componentAlias] = $queryPart;

                if (!empty($joinCondition)) {
                    $this->addPendingJoinCondition($componentAlias, $joinCondition);
                }
            }

            if ($loadFields) {
                $restoreState = false;

                // load fields if necessary
                if ($loadFields && empty($this->_dqlParts['select'])) {
                    $this->_pendingFields[$componentAlias] = array('*');
                }
            }

            $parent = $prevPath;
        }

        $table = $this->_queryComponents[$componentAlias]['table'];

        return $this->buildIndexBy($componentAlias, $mapWith);
    }
}