<?php

/**
 * Base project form.
 * 
 */
class artBaseForm extends sfFormSymfony {

  public $levels = array();
  public $divLevels = false;
  public $translationLevels = array();
  public $requiredFields = array();
  public $enableRequiredsFieldText = true;
  public $requiredFieldText = '*';
  protected $_widgetSchemaClass = 'artWidgetFormSchema';
  protected $_validatorSchemaClass = 'artValidatorSchema';

  /**
   * @var sfWebRequest
   */
  public static $request = null;

  /**
   * @var sfContext
   */
  public static $context = null;

  /**
   * @var myUser
   */
  public static $user = null;

  public function __construct($defaults = array(), $options = array(), $CSRFSecret = null) {
    self::getContext()->getConfiguration()->loadHelpers(array('I18N', 'Tag'));

    $this->setLevels();

    $this->setDefaults($defaults);
    $this->options = $options;
    $this->localCSRFSecret = $CSRFSecret;

    //wlasne klasy validatorSchema i widgetSchema
    $this->validatorSchema = new $this->_validatorSchemaClass();
    $this->widgetSchema = new $this->_widgetSchemaClass();
    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    $this->setup();
    $this->configure();

    if ($this->enableRequiredsFieldText)
      $this->setRequiredLabels();

    $this->addCSRFProtection($this->localCSRFSecret);
    $this->resetFormFields();
  }

  public function setWidgets(array $widgets) {
    $this->setWidgetSchema(new artWidgetFormSchema($widgets));

    return $this;
  }

  public function getHiddenFields() {
    $fields = array();

    foreach ($this->getFormFieldSchema()->getHiddenFields(true) as $field)
      $fields[] = $field->getName();

    return $fields;
  }

  public function setValidators(array $validators) {
    $this->setValidatorSchema(new artValidatorSchema($validators));

    return $this;
  }

  public function bindFromRequest($request = null) {
    if (is_null($request))
      $request = self::getRequest();

    if ($request->hasParameter($this->getName()) && $request->isMethod('POST'))
      $this->bind($request->getParameter($this->getName()), $request->getFiles($this->getName()));
  }

  public function bindFromRequestAndSave($request = null) {
    $this->bindFromRequest($request);

    if ($this->isValid()) {
      $save = $this->save();

      return isset($save) && !is_null($save) ? $save : true;
    }

    return false;
  }

  public function save($con = null) {
    
  }

  public function bind(array $taintedValues = null, array $taintedFiles = null) {
    //pętla przenosi informacje o zuploadowanym ajaxowo obrazku do odpowiedniej tablicy wartosci
    foreach ($this->widgetSchema->getAjaxImageFields() as $imageField) {
      if (isset($taintedValues[$imageField])) {
        $taintedFiles[$imageField] = $taintedValues[$imageField];
        $taintedFiles[$imageField]['tmp_name'] = artSettings::getUploadsTmpDir() . '/' . $taintedFiles[$imageField]['tmp_name'];
        unset($taintedValues[$imageField]);
      }
    }

    foreach ($this->validatorSchema->getFields() as $name => $validator)
      if ($validator instanceof sfArtValidatorCheckbox)
        if (isset($taintedValues[$name]) && $taintedValues[$name] == 'on')
          $taintedValues[$name] = 1;

    parent::bind($taintedValues, $taintedFiles);
  }

  public function __toString() {
    try {
      return $this->renderLevel();
    } catch (Exception $e) {
      self::setToStringException($e);

      return 'Exception: ' . $e->getMessage();
    }
  }

  public function getPreferredCulture() {
    return sfConfig::get('sf_cultures', array('pl'));
  }

  public function getCultureLabels() {
    $cultureLabels = array();

    foreach ($this->getPreferredCulture() as $culture)
      $cultureLabels[$culture] = sfCultureInfo::getInstance()->getLanguage($culture);

    return $cultureLabels;
  }

  public function embedI18nWithLabels() {
    $this->embedI18n($this->getPreferredCulture());
    $this->widgetSchema->setLabels($this->getCultureLabels());
  }

  public function getUserAttribute($name, $default = null) {
    return $this->getUser()->getAttribute($name, $default);
  }

  public function getUserLang() {
    return $this->getUser()->getCulture();
  }

  public function getUser() {
    return BaseForm::getStaticUser();
  }

  public static function getUserId() {
    return BaseForm::getStaticUser()->getId();
  }

  public function setRequiredFields($fields = array()) {
    $this->requiredFields = $fields;
  }

  public function setRequiredLabels() {
    if ($this->requiredFields === false)
      return;

    if ($this instanceof sfFormFilter)
      return;

    if (empty($this->requiredFields))
      foreach ($this->validatorSchema->getFields() as $name => $validator)
        if ($validator->getOption('required') && (!($validator instanceof sfArtValidatorCheckbox)) && (!($validator instanceof sfValidatorPass)))
          $this->requiredFields[] = $name;

    foreach ($this->requiredFields as $value) {
      $label = $this->widgetSchema[$value]->getLabel();

      if ($label === false)
        continue;

      if ($label == '')
        $label = str_replace(array('_id', '_'), array('', ' '), ucfirst($value));

      $label = '<span class="art-required-field-text">' . __($label) . '</span> <span class="art-required-field">' . $this->requiredFieldText . '</span>';

      $this->widgetSchema[$value]->setLabel($label);
    }
  }

  public function isDivLevels() {
    return $this->divLevels;
  }

  public function setDivLevels($divLevels = true) {
    $this->divLevels = $divLevels;
  }

  public function renderLevel($levels = array(), $attributes = array(), $forceRenderLevels = false) {
    if ($this->divLevels)
      $forceRenderLevels = true;

    artEscaper::escape($levels, array());

    if (!empty($this->levels) || empty($levels))
      $levels = $this->levels;

    if (isset($levels['translation'])) {
      $this->setTranslationLevelsArray($levels['translation'], $levels);
      unset($levels['translation']);
    }

    if (empty($levels)) {
      if (!$forceRenderLevels)
        return $this->render($attributes);
      else
        $levels = $this->autoSetLevels();
    }

    $levelRenderer = new FormLevelRenderer($this, $levels, $attributes);

    if ($this->isDivLevels())
      $levelRenderer->setDivLevels(true);

    return $levelRenderer->__toString();
  }

  final protected function autoSetLevels() {
    $levels = array();

    foreach ($this->getWidgetSchema()->getPositions() as $name)
      if (!in_array($name, array_keys($this->embeddedForms)) && $name != '_csrf_token')
        $levels[] = array($name);


    foreach ($this->embeddedForms as $formName => $form) {
      $embeddedFormLevels = array();

      foreach ($form->getWidgetSchema()->getPositions() as $name)
        $embeddedFormLevels[] = array($name);

      if (in_array($formName, $this->getPreferredCulture()))
        $this->setTranslationLevelsArray($embeddedFormLevels, $levels);
      else
        $levels[$formName] = $embeddedFormLevels;
    }

    return $levels;
  }

  public function getTranslationLevelsArray() {
    return array();
  }

  public function setTranslationLevelsArray($translationLevelsArray, &$levels) {
    foreach ($this->getPreferredCulture() as $culture)
      $levels[$culture] = $translationLevelsArray;
  }

  public function getLevelsArray() {
    return array();
  }

  public function setLevels() {
    $this->levels = $this->getLevelsArray();
    $translationLevelsArray = $this->getTranslationLevelsArray();

    if (!empty($translationLevelsArray))
      $this->setTranslationLevelsArray($translationLevelsArray, $this->levels);
  }

  public static function setRequest(sfWebRequest $request) {
    BaseForm::$request = $request;
  }

  /**
   * @return sfWebRequest
   */
  public static function getRequest() {
    if (is_null(BaseForm::$request))
      BaseForm::$request = BaseForm::getContext()->getRequest();

    return BaseForm::$request;
  }

  public static function setUser(myUser $user) {
    BaseForm::$user = $user;
  }

  /**
   * @return myUser
   */
  public static function getStaticUser() {
    if (is_null(BaseForm::$user))
      BaseForm::$user = BaseForm::getContext()->getUser();

    return BaseForm::$user;
  }

  /**
   * @return sfContext
   */
  public static function getContext() {
    if (is_null(BaseForm::$context))
      BaseForm::$context = sfContext::getInstance();

    return BaseForm::$context;
  }

  public static function setContext(sfContext $context) {
    BaseForm::$context = $context;
  }

  public static function loadI18NHelper() {
    self::getContext()->getConfiguration()->loadHelpers(array('I18N'));
  }

  public function getRegonValidator($required = false) {
    return new sfValidatorOr(array(
      new sfValidatorRegex(array('pattern' => '/^[0-9]{14}$/', 'required' => $required)),
      new sfValidatorRegex(array('pattern' => '/^[0-9]{9}$/', 'required' => $required))
        ), array('required' => $required), array('invalid' => 'REGON is invalid.'));
  }

  public function disableRequiredsFieldText() {
    $this->enableRequiredsFieldText = false;
  }

  public function setRequiredFieldText($text) {
    $this->requiredFieldText = $text;
  }

  /**
   * Funkcja zwraca pola ktore maja byc uzyte w formularzach translacyjnych.
   * Zwrocenie pustej tablicy oznacza uzycie wszystkich dostepnych pol
   * @return array
   */
  protected function useTranslationFields() {
    return array('id', 'title');
  }

  /**
   * Embeds i18n objects into the current form.
   * Nadpisana aby wlaczac tylko te pola ktore nas interesuja.
   * Pola zwracane przez funkcje useTranslationFields()
   *
   * @param array   $cultures   An array of cultures
   * @param string  $decorator  A HTML decorator for the embedded form
   */
  public function embedI18n($cultures, $decorator = null) {
    if (!$this->isI18n()) {
      throw new sfException(sprintf('The model "%s" is not internationalized.', $this->getModelName()));
    }

    $class = $this->getI18nFormClass();
    foreach ($cultures as $culture) {
      $i18nObject = $this->getObject()->Translation[$culture];
      $i18n = new $class($i18nObject);

      if (false === $i18nObject->exists()) {
        unset($i18n[$this->getI18nModelPrimaryKeyName()], $i18n[$this->getI18nModelI18nField()]);
      }

      $translationFields = $this->useTranslationFields();
      if (count($translationFields) > 0) {
        foreach ($i18n->getFields() as $name => $field) {
          if (!in_array($name, $translationFields)) {
            unset($i18n[$name]);
          }
        }
      }

      $this->embedForm($culture, $i18n, $decorator);
    }
  }

}
