<?php

/**
 * Description of artBaseFormDoctrine
 *
 
 */
abstract class artBaseFormDoctrine extends sfFormDoctrine {

  /**
   * @param null $request
   * @return bool|mixed
   */
  public function bindFromRequestAndSave($request = null) {
    if (parent::bindFromRequestAndSave($request))
      return $this->getObject();
    else
      return false;
  }

  /**
   * Funkcja zwraca pola ktore maja byc uzyte w formularzach translacyjnych.
   * Zwrocenie pustej tablicy oznacza uzycie wszystkich dostepnych pol
   * @return array
   */
  protected function useTranslationFields() {
    return array();
  }

  /**
   * Embeds i18n objects into the current form.
   * Nadpisana aby wlaczac tylko te pola ktore nas interesuja.
   * Pola zwracane przez funkcje useTranslationFields()
   *
   * @param array   $cultures   An array of cultures
   * @param string  $decorator  A HTML decorator for the embedded form
   */
  public function embedI18n($cultures, $decorator = null) {
    if (!$this->isI18n()) {
      throw new sfException(sprintf('The model "%s" is not internationalized.', $this->getModelName()));
    }

    $class = $this->getI18nFormClass();
    foreach ($cultures as $culture) {
      $i18nObject = $this->getObject()->Translation[$culture];
      $i18n = new $class($i18nObject);

      if (false === $i18nObject->exists()) {
        unset($i18n[$this->getI18nModelPrimaryKeyName()], $i18n[$this->getI18nModelI18nField()]);
      }

      $translationFields = $this->useTranslationFields();
      if (count($translationFields) > 0) {
        foreach ($i18n->getWidgetSchema()->getFields() as $name => $field) {
          if (!in_array($name, $translationFields)) {
            unset($i18n[$name]);
          }
        }
      }

      $this->embedForm($culture, $i18n, $decorator);
    }
  }

}
