<?php

/**
 * artWidgetFormSchemaFormatterBootstrap wykorzystywany do generowania formularza
 * w postaci Boostrapowej
 *
 * @package    lib
 * @subpackage formatter

 */
class artWidgetFormSchemaFormatterBootstrap extends artWidgetFormSchemaFormatter {


  protected
      $rowFormat = '
          <div class="control-group fl %is_error%">
              %label%
              <div class="controls">
                  %error%
                  %field%
                  %hidden_fields%
              </div>
          </div>
          <div class="clear"></div>',
      $errorRowFormat = "%errors%",
      $helpFormat = '%help%',
      $errorListFormatInARow = "<ul class=\"errors \">\n%errors%</ul>\n",
      $errorRowFormatInARow = "<li><i class='glyphicon glyphicon-question-sign'></i> %error%</li>\n",
      $namedErrorRowFormatInARow = "<li>%name%: %error%</li>\n",
      $rowEmbedded = '
            <div class="shortcode_tabs type1">
              <div class="all_heads_cont">
                %headers%
              </div>
              <div class="all_body_cont">
                %containers%
              </div>
            </div>',
      $headerEmbedded = '<div class="btn btn-primary shortcode_tab_item_title%active%%is_error%" onclick="ManageForm.changeTab(this, \'%container%\');">%icon%<span>%label%</span></div>',
      $containerEmbedded = '<div class="shortcode_tab_item_body %container%%active%%is_error%">
              %content%</div>',
      $decoratorFormat = "%content%",
      $translationCatalogue = 'messages',
      $embeddedIcons = false;

  /**
   * Nadpisana zeby w przypadku ustawienia label na false nic nie generowac oraz
   * dodaje atrybuty potrzebne do html dla labeli
   * @param type $name
   * @param type $attributes
   * @return string
   */
  public function generateLabel($name, $attributes = array()) {
    $labelName = $this->generateLabelName($name);
    
    if (false === $this->widgetSchema->getLabel($name)) {
      return '';
    }

    if (!isset($attributes['for'])) {
      $attributes['for'] = $this->widgetSchema->generateId($this->widgetSchema->generateName($name));

      if (isset($attributes['class'])) {
        $attributes['class'] .= 'control-label';
      } else {
        $attributes['class'] = 'control-label';
      }
    }

    return $this->widgetSchema->renderContentTag('label', $labelName, $attributes);
  }
  
  /**
   * Ustawia flage do generowania ikon przy embeddedForms
   * @param boolean $boolean
   */
  public function setEmbeddedIcons($boolean) {
    $this->embeddedIcons = $boolean;
  }
  
  /**
   * Nie chcemy aby errory byly propagowane do samej gory, wiec nadpisujemy funkcje
   * @param type $errors
   * @param type $prefix
   * @return type
   */
  protected function unnestErrors($errors, $prefix = '') {
    $newErrors = array();

    foreach ($errors as $name => $error) {
      if ($error instanceof ArrayAccess || is_array($error)) {
        // Nie chcemy zeby nam errory byly propagowane do samej gory
        //$newErrors = array_merge($newErrors, $this->unnestErrors($error, ($prefix ? $prefix . ' > ' : '') . $name));
      } else {
        if ($error instanceof sfValidatorError) {
          $err = $this->translate($error->getMessageFormat(), $error->getArguments());
        } else {
          $err = $this->translate($error);
        }

        if (!is_integer($name)) {
          $newErrors[] = strtr($this->getNamedErrorRowFormatInARow(), array('%error%' => $err, '%name%' => ($prefix ? $prefix . ' > ' : '') . $name));
        } else {
          $newErrors[] = strtr($this->getErrorRowFormatInARow(), array('%error%' => $err));
        }
      }
    }

    return $newErrors;
  }

  /**
   * Funkcja wykorzystywana do stworzenia tablicy z danymi do renderowania zakladek.
   * @param type $name
   * @param type $field
   * @param type $errors
   * @param type $help
   * @param type $hiddenFields
   * @param type $active
   * @return type
   */
  public function formatRowEmbedded($name, $field, $errors = array(), $help = '', $hiddenFields = null, $active = false) {
    $labelName = $this->generateLabelName($name);
    $containerName = $name;
    
    $icon = '';
    if ($this->embeddedIcons) {
      $icon = '<i class="glyphicon glyphicon-'.$name.'"></i>';
    }

    $header = strtr($this->headerEmbedded, array(
      '%label%' => $labelName,
      '%container%' => $containerName,
      '%icon%' => $icon,
      '%is_error%' => (count($errors) > 0) ? ' error' : '',
      '%active%' => ($active) ? ' active' : '',
    ));
    
    $container = strtr($this->containerEmbedded, array(
      '%content%' => $this->formatRow('', $field, $errors, $help, $hiddenFields),
      '%container%' => $containerName,
      '%is_error%' => (count($errors) > 0) ? ' error' : '',
      '%active%' => ($active) ? ' active' : '',
    ));
        
    return array(
      'header' => $header,
      'container' => $container,
    );
  }

  /**
   * Funkcja renderuje zakladki
   * @param type $rows
   * @return type
   */
  public function formatRowsEmbedded($rows) {
    $header = '';
    $container = '';

    foreach ($rows as $row) {
      $header .= $row['header'];
    }

    foreach ($rows as $row) {
      $container .= $row['container'];
    }
    
    return strtr($this->rowEmbedded, array(
      '%headers%' => $header,
      '%containers%' => $container,
    ));
  }
}
