<?php

class artDoctrineFormFilterGenerator extends sfDoctrineFormFilterGenerator
{

  public function initialize(sfGeneratorManager $generatorManager)
  {
    parent::initialize($generatorManager);
    
    $this->setTheme('arteneotheme');
  }
  
  public function getWidgetClassForColumn($column)
  {
    if ($column->isPrimarykey() || $column->isForeignKey())
    {
      return 'sfArtWidgetFormDoctrineJQueryMultiSelect';
    }

    switch ($column->getDoctrineType())
    {
      case 'boolean':
        return 'sfArtWidgetFormFilterBoolRadio';
      case 'date' :
        return 'sfArtWidgetFormInputJQueryDateRange';
      case 'datetime' :
      case 'timestamp' :
        return 'sfArtWidgetFormInputJQueryDateTimeRange';
      case 'enum':
        return 'sfArtWidgetFormDoctrineJQueryMultiselect';
      default:
        return 'sfArtWidgetFormFilterInput';
    }
  }

  public function getWidgetOptionsForColumn($column)
  {
    if ($column->isPrimarykey() || $column->isForeignKey())
    {
      return "array('multiple' => true, 'model' => \$this->getRelatedModelName('" . $column->getRelationKey('alias') . "'))";
    }

    switch ($column->getDoctrineType())
    {
      case 'boolean':
        return '';
      case 'date':
      case 'datetime' :
      case 'timestamp' :
        return "array('culture' => sfContext::getInstance()->getUser()->getCulture() )";
        break;
      default:
        return parent::getWidgetOptionsForColumn($column);
    }
  }

  public function getValidatorClassForColumn($column)
  {
    if ($column->isPrimarykey() || $column->isForeignKey())
    {
      return 'sfValidatorDoctrineChoice';
    }

    switch ($column->getDoctrineType())
    {
      case 'date':
      case 'datetime' :
      case 'timestamp' :
        return 'sfValidatorDateRange';
        break;
      default:
        return parent::getValidatorClassForColumn($column);
    }
  }

  public function getValidatorOptionsForColumn($column)
  {
    if ($column->isForeignKey())
    {
      $columns = $column->getForeignTable()->getColumns();
      
      foreach ($columns as $name => $col)
      {
        if (isset($col['primary']) && $col['primary'])
        {
          break;
        }
      }

      return "array('required' => false, 'model' => \$this->getRelatedModelName('" . $column->getRelationKey('alias') . "'), 'column' => '" . $column->getForeignTable()->getFieldName($name) . "', 'multiple'=>true)";
    }
    else if ($column->isPrimaryKey())
    {
      return "array('required' => false, 'model' => \$this->getRelatedModelName('" . $this->table->getOption('name') . "'), 'column' => '" . $column->getFieldName() . "', 'multiple'=>true)";
    }

    switch ($column->getDoctrineType())
    {
      case 'date':
        return "array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))";
      case 'datetime' :
      case 'timestamp' :
        return "array('required' => false, 'from_date' => new sfValidatorDateTime(array('required' => false)), 'to_date' => new sfValidatorDateTime(array('required' => false)))";
        break;
      default:
        return parent::getValidatorOptionsForColumn($column);
    }
  }

}
