<?php

class artDoctrineFormGenerator extends sfDoctrineFormGenerator
{

  public function initialize(sfGeneratorManager $generatorManager)
  {
    parent::initialize($generatorManager);
    
    $this->setTheme('arteneotheme');
  }
  
  public function getWidgetClassForColumn($column)
  {
    if ($column->isForeignKey())
      return 'sfArtWidgetFormDoctrineJQueryMultiSelect';
    
    if ($column->isPrimaryKey())
      return 'sfWidgetFormInputHidden';
    
    switch ($column->getDoctrineType())
    {
      case 'timestamp':
        return 'sfArtWidgetFormInputJQueryDateTime';
      case 'date':
        return 'sfArtWidgetFormInputJQueryDate';
      case 'string':
        return  null === $column->getLength() || $column->getLength() > 255 ? 'sfWidgetFormTextarea' : 'sfArtWidgetFormInputText';
      case 'boolean':
        return  'sfWidgetFormInputCheckbox';
      case 'blob':
      case 'clob':
        return  'sfArtWidgetFormTextarea';
      case 'date':
        return  'sfWidgetFormDate';
      case 'time':
        return  'sfWidgetFormTime';
      case 'timestamp':
        return  'sfWidgetFormDateTime';
      case 'enum':
        return  'sfWidgetFormChoice';
      default:
        return  'sfArtWidgetFormInputText';
    }
  }

  public function getValidatorClassForColumn($column)
  {
    switch ($column->getDoctrineType())
    {
      case 'timestamp':
      case 'date':
        return 'sfValidatorDateTime';
        break;
      default:
        return parent::getValidatorClassForColumn($column);
    }
  }
}
