<?php
/**
 * Description of artDoctrineGenerator
 *
 
 */

class artDoctrineGenerator extends sfDoctrineGenerator
{

    public $dateFormat = 'f';

    public function getLinkToAction($actionName, $params, $pk_link = false)
    {
        $action = isset($params['action']) ? $params['action'] : 'List' . sfInflector::camelize($actionName);

        $url_params = isset($params['url_params']) ? '?' . $params['url_params'] : '';


        if ($pk_link) {
            $pk = $this->getPrimaryKeyUrlParams();


            if ($url_params != '')
                $url_params = str_replace('?', '&', $url_params);

            $url_params .= '\' . htmlspecialchars_decode($configuration->getFollowParametersString($sf_request))';
        } else {
            $pk = '\'';

            if ($url_params == '')
                $url_params = '\' . htmlspecialchars_decode($configuration->getFollowParametersStringWithQuestionMark($sf_request))';
            else
                $url_params .= '\' . htmlspecialchars_decode($configuration->getFollowParametersString($sf_request))';
        }

        $name = '__(\'' . $params['label'] . '\', array(), \'' . $this->getI18nCatalogue() . '\')';

        if (isset($params['url']))
            $url = 'url_for(\'' . $params['url'] . '\')';
        else
            $url = 'url_for(\'' . $this->getModuleName() . '/' . $action . '?' . $pk . ') . \'' . $url_params;

        if (isset($params['ajax_action']) && $params['ajax_action']) {
            if (!isset($params['ajax_params']))
                $params['ajax_params'] = array();
            if (!isset($params['params']))
                $params['params'] = array();

            return '[?php echo ' . $this->createAjaxLink($name, $url, $params['params'], $params['ajax_params']) . '?]';
        } else
            return '[?php echo link_to(\'' . artBox::beginBox('horizontal_span') . "' . $name . '" . artBox::endBox('horizontal_span') . '\', ' . $url . ', ' . $this->asPhp($params['params']) . ') ?]';
    }

    public function addCredentialCondition($content, $params = array())
    {
        if (isset($params['user_condition'])) {
            $condition = $params['user_condition'];

            return <<<EOF
[?php if (\$sf_user->$condition()): ?]
$content
[?php endif; ?]

EOF;
        } else if (isset($params['configuration_condition'])) {
            $condition = $params['configuration_condition'];

            return <<<EOF
[?php if (\$configuration->$condition()): ?]
$content
[?php endif; ?]

EOF;
        } else if (isset($params['condition'])) {
            $condition = $params['condition'];

            return <<<EOF
[?php if ($condition): ?]
$content
[?php endif; ?]

EOF;
        } else if (isset($params['object_condition']) && !isset($params['batch_action'])) {
            $condition = '$' . $this->getSingularName() . '->' . $params['object_condition'] . '()';

            return <<<EOF
[?php if ($condition): ?]
$content
[?php endif; ?]

EOF;
        } else
            return parent::addCredentialCondition($content, $params);
    }

    public function setDateFormat($dateFormat)
    {
        $this->dateFormat = $dateFormat;
    }

    public function renderField($field)
    {
        $html = $this->getColumnGetter($field->getName(), true);

        if ($renderer = $field->getRenderer()) {
            $html = sprintf("call_user_func_array(%s, array_merge(array(%s), %s))", $this->asPhp($renderer), $html, $this->asPhp($field->getRendererArguments()));
        } else if ($field->isComponent()) {
            return sprintf("get_component('%s', '%s', array('type' => 'list', '%s' => \$%s))", $this->getModuleName(), $field->getName(), $this->getSingularName(), $this->getSingularName());
        } else if ($field->isPartial()) {
            return sprintf("get_partial('%s/%s', array('type' => 'list', '%s' => \$%s))", $this->getModuleName(), $field->getName(), $this->getSingularName(), $this->getSingularName());
        } else if ('Boolean' == $field->getType()) {
            $html = sprintf("get_partial('%s/list_field_boolean', array('value' => %s))", $this->getModuleName(), $html);
        } else if ('Date' == $field->getType())
            $html = $this->renderFieldDate($field, $html);

        if ($field->isLink()) {
            $action = $field->getConfig('link_action', 'edit');
            if ($action == 'edit')
                $url = $this->getUrlForAction($action);
            else
                $url = $this->getModuleName() . '/' . $action . '?id=\' . $' . $this->getSingularName() . '->getId()';

            if (!$field->getConfig('ajax_action', false))
                $html = sprintf("link_to(%s, '%s', \$%s)", $html, $url, $this->getSingularName());
            else {
                $ajaxParams = $field->getConfig('ajax_params', array());
                $htmlParams = $field->getConfig('params', array());
                $url = 'url_for(\'' . $url . ')';
                $html = $this->createAjaxLink($html, $url, $htmlParams, $ajaxParams);
            }
        }

        if (!is_null($renderer = $field->getConfig('link_renderer', null))) {
            $singularName = $this->getSingularName();
            $html = sprintf("$html ? call_user_func_array(%s, array_merge(array($%s), %s)) : '&nbsp;'", $this->asPhp($renderer), $singularName, $this->asPhp($field->getRendererArguments()));
        }

        return $html;
    }

    protected function renderFieldDate($field, $html)
    {
        $dateFormat = $field->getConfig('date_format', $this->dateFormat);
        if (strpos($dateFormat, '<') === false) {
            $html = sprintf("(false !== strtotime($html) && (int)" . $html . " != 0) ? format_date(%s, \"%s\") : '&nbsp;'", $html, $dateFormat);
        } else {
            $dateFormat = str_replace(array('<', '>'), array('', ''), $dateFormat);
            $html = sprintf("(false !== strtotime($html) && (int)" . $html . " != 0) ? date(\"%s\", (strtotime($html))) : '&nbsp;'", $dateFormat);
        }

        return $html;
    }

    public function getRoutePrefix()
    {
        return $this->params['route_prefix'];
    }

    public function createAjaxLink($name, $url, $htmlParams, $ajaxParams)
    {
        if (isset($ajaxParams['url']))
            $url = $ajaxParams['url'];

        $defaultAjaxParams = array(
            'url' => '%%toChange%%',
            'loading' => "clickedElement.artIndicator({position: '', view: '1'})",
            'success' => 'clickedElement.html(data)',
        );

        if (isset($ajaxParams['update']))
            unset($defaultAjaxParams['success']);

        $ajaxParams = $this->asPhp(array_merge($defaultAjaxParams, $ajaxParams));

        $ajaxParams = str_replace("'%%toChange%%'", $url, $ajaxParams);

        $htmlParams = $this->asPhp(array_merge(array(
            'onclick' => 'var clickedElement = $(this).parent();'
        ), $htmlParams));

        return "jq_link_to_remote_with_onclick($name, $ajaxParams, $htmlParams)";
    }
}
