<?php
/**
 * Description of artLogDoctrineGenerator
 *
 
 */

class artLogDoctrineGenerator extends artDoctrineGenerator
{

    public $oldFieldNames = array();
    public $newFieldNames = array();
    public $canAddI18nLogFields = true;

    public function getAllFieldNames($withM2M = true)
    {
        $relations = $this->table->getRelations();
        $relationsArray = array();
        $this->canAddI18nLogFields = true;

        foreach ($relations as $relationName => $relation)
            if ($relationName != 'Translation' && $relation->getLocal() != 'id')
                $relationsArray[$relation->getLocal()] = $relationName;

        $names = array();

        foreach ($this->getColumns() as $name => $column) {
            if ($name != 'id' && !artString::startsWith('old_', $name) && !artString::startsWith('new_', $name))
                $names = $this->addI18nLogFields($names);

            $names[$name] = isset($relationsArray[$name]) ? $relationsArray[$name] : $name;
        }

        return $names;
    }

    protected function addI18nLogFields($names)
    {
        if ($this->table->hasTemplate('Doctrine_Template_I18nLog') && $this->canAddI18nLogFields) {
            $this->canAddI18nLogFields = false;
            $template = $this->table->getTemplate('Doctrine_Template_I18nLog');
            $fields = $template->getOption('fields');

            foreach ($fields as $field)
                $names[$field] = $field;

            $names['old_lang'] = 'old_lang';
            $names['new_lang'] = 'new_lang';
        }

        return $names;
    }

    public function renderField($field)
    {
        $html = $this->getColumnGetter($field->getName(), true);

        if ($renderer = $field->getRenderer()) {
            if ($field->getName() == 'flag')
                $html = sprintf("call_user_func_array(%s, array_merge(array(%s), %s));", $this->asPhp($renderer), $html, $this->asPhp($field->getRendererArguments()));
            else
                $html = sprintf("$html ? call_user_func_array(%s, array_merge(array(%s), %s)) : '&nbsp;'", $this->asPhp($renderer), $html, $this->asPhp($field->getRendererArguments()));
        } else if ($field->isComponent()) {
            return sprintf("get_component('%s', '%s', array('type' => 'list', '%s' => \$%s))", $this->getModuleName(), $field->getName(), $this->getSingularName(), $this->getSingularName());
        } else if ($field->isPartial()) {
            return sprintf("get_partial('%s/%s', array('type' => 'list', '%s' => \$%s))", $this->getModuleName(), $field->getName(), $this->getSingularName(), $this->getSingularName());
        } else if ('Boolean' == $field->getType()) {
            $html = sprintf("get_partial('%s/list_field_boolean', array('value' => %s))", $this->getModuleName(), $html);
        }

        if (!is_null($renderer = $field->getConfig('link_renderer', null))) {
            $singularName = $this->getSingularName();
            $html = sprintf("$html ? call_user_func_array(%s, array_merge(array($%s), %s)) : '&nbsp;'", $this->asPhp($renderer), $singularName, $this->asPhp($field->getRendererArguments()));
        }

        return $html;
    }

}
