<?php

class flatyDoctrineGenerator extends sfDoctrineGenerator {

  /**
   * Returns HTML code for an action link.
   *
   * @param string  $actionName The action name
   * @param array   $params     The parameters
   * @param boolean $pk_link    Whether to add a primary key link or not
   *
   * @return string HTML code
   */
  public function getLinkToAction($actionName, $params, $pk_link = false) {
    $action = isset($params['action']) ? $params['action'] : 'List' . sfInflector::camelize($actionName);

    if (isset($params['params']['icon-class'])) {
      $icon = $params['params']['icon-class'];
      unset($params['params']['icon-class']);
    } else {
      $icon = 'icon-question-sign';
    }

    $url_params = $pk_link ? '?' . $this->getPrimaryKeyUrlParams() : '\'';

    return '[?php echo link_to(\'<i class="' . $icon . '"></i> \'.__(\'' . $params['label'] . '\', array(), \'' . $this->getI18nCatalogue() . '\'), \'' . $this->getModuleName() . '/' . $action . $url_params . ', ' . $this->asPhp($params['params']) . ') ?]';
  }

  public function addCredentialCondition($content, $params = array()) {
    if (isset($params['user_condition'])) {
      $condition = $params['user_condition'];

      return <<<EOF
[?php if (\$sf_user->$condition()): ?]
$content
[?php endif; ?]

EOF;
    } else if (isset($params['configuration_condition'])) {
      $condition = $params['configuration_condition'];

      return <<<EOF
[?php if (\$configuration->$condition()): ?]
$content
[?php endif; ?]

EOF;
    } else if (isset($params['condition'])) {
      $condition = $params['condition'];

      return <<<EOF
[?php if ($condition): ?]
$content
[?php endif; ?]

EOF;
    } else if (isset($params['object_condition']) && !isset($params['batch_action'])) {
      $condition = '$' . $this->getSingularName() . '->' . $params['object_condition'] . '()';

      return <<<EOF
[?php if ($condition): ?]
$content
[?php endif; ?]

EOF;
    } else
      return parent::addCredentialCondition($content, $params);
  }

}
