<?php
/**
 * Description of artReportMatrixDoctrinePager
 *
 
 */
class artReportMatrixDoctrinePager extends artDoctrinePager
{

    public $inputVertical;
    public $connection;
    public $queryToAllResults;

    public function setInputVertical($inputVertical)
    {
        $this->inputVertical = $inputVertical;
    }

    public function getInputVertical()
    {
        return $this->inputVertical;
    }

    public function getCountOfQuery()
    {
        $query = $this->getQuery()->copy();

        $rootAlias = $query->getRootAlias();
        $query->select(' ' . $rootAlias . '.' . $this->getInputVertical() . ' as ' . $this->getInputVertical());
        $query->groupby($rootAlias . '.' . $this->getInputVertical());

        return $query->count();
    }

    public function getVerticals()
    {
        $queryVertical = clone $this->getQuery();

        $rootAlias = $queryVertical->getRootAlias();
        $queryVertical->addSelect('DISTINCT(' . $rootAlias . '.' . $this->getInputVertical() . ') as ' . $this->getInputVertical());
        $r = $queryVertical->execute(array(), Doctrine::HYDRATE_NONE);
        $verticals = array();

        foreach ($r as $row)
            $verticals[] = $row[0];

        return $verticals;
    }

    public function setConnection($connection = null)
    {
        if (is_null($connection))
            $this->connection = Doctrine_Manager::getInstance()->connection();
        else
            $this->connection = $connection;
    }

    public function setQueryToAllResults()
    {
        $this->queryToAllResults = clone $this->getQuery();
    }

    public function getAllResults($hydrationMode = null)
    {
        return $this->queryToAllResults->execute(array(), $hydrationMode);
    }

    public function init()
    {
        $this->resetIterator();
        $this->setConnection();
        $this->setQueryToAllResults();

        $queryCount = $this->getCountOfQuery();
        $this->setNbResults($queryCount);

        $query = $this->getQuery();

        if (0 == $this->getPage() || 0 == $this->getMaxPerPage() || 0 == $this->getNbResults())
            $this->setLastPage(1);
        else {
            $offset = ($this->getPage() - 1) * $this->getMaxPerPage();

            $this->setLastPage(ceil($this->getNbResults() / $this->getMaxPerPage()));

            $query->offset($offset)
                ->limit($this->getMaxPerPage());
        }

        $verticals = $this->getVerticals();
        $rootAlias = $query->getRootAlias();

        if (empty($verticals))
            $query->andWhere('1=0');
        else
            $query->andWhereIn($rootAlias . '.' . $this->getInputVertical(), $verticals);

        $query->offset(0)->limit(0);
    }

}