<?php

/**
 * Description of artChartDoctrineRouteCollection
 *
 
 */
class artChartDoctrineRouteCollection extends sfDoctrineRouteCollection
{

    protected function getDefaultActions()
    {
        $actions = array('list', 'chartList', 'exportCsv', 'exportExcel');

        return $actions;
    }

    protected function getRouteForChartList()
    {
        $action = 'indexChart';

        return new sfRoute($this->options['prefix_path'] . '/' . $action,
            array('module' => $this->options['module'], 'action' => $action)
        );
    }

    protected function getRouteForExportCsv()
    {
        $action = 'exportCsv';

        return new sfRoute($this->options['prefix_path'] . '/' . $action,
            array('module' => $this->options['module'], 'action' => $action)
        );
    }

    protected function getRouteForExportExcel()
    {
        $action = 'exportExcel';

        return new sfRoute($this->options['prefix_path'] . '/' . $action,
            array('module' => $this->options['module'], 'action' => $action)
        );
    }

}
