<?php
/**
 * Description of artDoctrineRouteCollection
 *
 
 */
class artDoctrineRouteCollection extends sfDoctrineRouteCollection
{

    protected function generateRoutes()
    {
        if (!isset($this->options['ajax_actions']))
            $this->options['ajax_actions'] = array();

        // collection actions
        if (isset($this->options['collection_actions'])) {
            foreach ($this->options['collection_actions'] as $action => $methods) {
                $this->routes[$this->getRoute($action)] = $this->getRouteForCollection($action, $methods);
            }
        }

        // "standard" actions
        $actions = false === $this->options['actions'] ? $this->getDefaultActions() : $this->options['actions'];
        foreach ($actions as $action) {
            $method = 'getRouteFor' . sfInflector::classify($action);
            if (!method_exists($this, $method)) {
                throw new InvalidArgumentException(sprintf('Unable to generate a route for the "%s" action.', $action));
            }

            $this->routes[$this->getRoute($action)] = $this->$method();
        }

        // object actions
        if (isset($this->options['object_actions'])) {
            foreach ($this->options['object_actions'] as $action => $methods) {
                $this->routes[$this->getRoute($action)] = $this->getRouteForObject($action, $methods);
            }
        }

        if ($this->options['with_wildcard_routes']) {
            // wildcard object actions
            $this->routes[$this->getRoute('object')] = new $this->routeClass(
                sprintf('%s/:%s/:action.:sf_format', $this->options['prefix_path'], $this->options['column']),
                array_merge(array('module' => $this->options['module'], 'sf_format' => 'html'), $this->options['default_params']),
                array_merge($this->options['requirements'], array('sf_method' => array('get', 'head'))),
                array('model' => $this->options['model'], 'type' => 'object', 'method' => $this->options['model_methods']['object'])
            );

            // wildcard collection actions
            $this->routes[$this->getRoute('collection')] = new $this->routeClass(
                sprintf('%s/:action/action.:sf_format', $this->options['prefix_path']),
                array_merge(array('module' => $this->options['module'], 'sf_format' => 'html'), $this->options['default_params']),
                array_merge($this->options['requirements'], array('sf_method' => 'post')),
                array('model' => $this->options['model'], 'type' => 'list', 'method' => $this->options['model_methods']['list'])
            );

            foreach ($this->options['ajax_actions'] as $action)
                $this->routes[$action] = new sfRoute(
                    sprintf('%s/:%s/:action.:sf_format', $this->options['prefix_path'], $this->options['column']),
                    array_merge(array('module' => $this->options['module'], 'sf_format' => 'html'), $this->options['default_params']),
                    array_merge($this->options['requirements'], array('sf_method' => 'get')),
                    array('model' => $this->options['model'], 'type' => 'object', 'method' => $this->options['model_methods']['object'])
                );
        }
    }

    protected function getRouteForList()
    {
        $listOptions = artArray::getFromArray($this->options, 'list_options', array());

        return new $this->routeClass(
            sprintf('%s.:sf_format', $this->options['prefix_path']),
            array_merge(array('module' => $this->options['module'], 'action' => $this->getActionMethod('list'), 'sf_format' => 'html'), $this->options['default_params']),
            array_merge($this->options['requirements'], array('sf_method' => array('get', 'head')), $listOptions),
            array('model' => $this->options['model'], 'type' => 'list', 'method' => $this->options['model_methods']['list'])
        );
    }

    protected function getRouteForLinkFilter()
    {
        return new $this->routeClass(
            $this->options['prefix_path'] . '/link_filter/:param.:sf_format',
            array_merge(array('module' => $this->options['module'], 'action' => 'linkFilter', 'sf_format' => 'html'), $this->options['default_params']),
            array_merge($this->options['requirements'], array('sf_method' => array('get', 'head'))),
            array('model' => $this->options['model'], 'type' => 'object', 'method' => $this->options['model_methods']['object'])
        );
    }

    protected function getDefaultActions()
    {
        $actions = array('list', 'new', 'create', 'edit', 'update', 'delete', 'link_filter');

        if ($this->options['with_show'])
            $actions[] = 'show';

        return $actions;
    }

}
