<?php

/*
 * This file is part of the symfony package.
 * (c) Fabien Potencier <fabien.potencier@symfony-project.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * sfPatternRouting class controls the generation and parsing of URLs.
 *
 * It parses and generates URLs by delegating the work to an array of sfRoute objects.
 *
 * @package    symfony
 * @subpackage routing
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: sfPatternRouting.class.php 32845 2011-07-28 11:50:48Z fabien $
 */
class artPatternRouting extends sfPatternRouting
{
  /**
   * Ustawia hosta
   * @param string $host Host
   */
  public function setHost($host) {
    $this->options['context']['host'] = $host;
  }
  
  /**
   * Ustawia prefix
   * @param string $prefix Prefix
   */
  public function setPrefix($prefix) {
    $this->options['context']['prefix'] = $prefix;
  }
}
