<?php

class artConfigurationTask extends sfBaseTask {

  public function configure() {
    $this->namespace = 'arteneo';
    $this->name = 'artconf';
    $this->aliases = array("ac");
    $this->briefDescription = 'Zmienia wartość rekordu w ArtConfiguration';
    $this->detailedDescription = <<<EOF
Task [arteneo:artconf|INFO] służy do zmiany ArtConfiguration
 
  [./symfony arteneo:artconf|INFO]
EOF;
    $this->addArguments(array(
        new sfCommandArgument('position', sfCommandArgument::REQUIRED, 'nazwa pozycji', null),
        new sfCommandArgument('value', sfCommandArgument::REQUIRED, 'wartość jaką chcemy nadać', null),
        new sfCommandArgument('lang', sfCommandArgument::OPTIONAL, 'język', 'all'),
    ));

    $this->addOptions(array(
        new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'doctrine'),
    ));
  }

  public function execute($arguments = array(), $options = array()) {
    sfApplicationConfiguration::getApplicationConfiguration('frontend', 'prod', true);
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

    //dostepne jezyki
    $langsInYml = sfConfig::get('sf_cultures', array());

    //pobranie pozycji
    $position = Doctrine::getTable('ArtConfiguration')->findOneByName($arguments['position']);

    if ($position != null) {

      //pobranie tlumaczen
      $query = Doctrine::getTable('ArtConfiguration')->createQuery('ac')
              ->where('ac.name = ?', $arguments['position'])
              ->leftJoin('ac.Translation t');

      //sprawdzenie jezykow 
      if ($arguments['lang'] == 'all') {
        $obj = $query->fetchOne();
        $translations = $obj->Translation;

        foreach ($translations as $translation) {
          if (in_array($translation->lang, $langsInYml)) {
            $translation->value = $arguments['value'];
            $translation->save();
          }
        }
        //porownanie ilosci jezykow w YML i DB; (tylko do wyswietlenia komunikatu)
        if (count($langsInYml) != $translations->count()) {
          $this->logSection('artconf', 'Liczba języków w YML i DB jest różna [YML: ' . count($langsInYml) . ' | DB: ' . $translations->count() . ']; sprawdź wpisy w bazie', null, 'ERROR');
        }
        $this->logSection('artconf', 'Zmieniono wartość pozycji ' . $arguments['position'] . ' dla wszystkich języków w. Nowa wartość: ' . $arguments['value'], null, 'INFO');
      } else {

        //sprawdzenie czy jezyki sa wlaczone w settings.yml
        if (in_array($arguments['lang'], $langsInYml)) {
          $obj = $query->andWhere('t.lang = ?', $arguments['lang'])->fetchOne();
          $translations = $obj->Translation;
          foreach ($translations as $translation) {
            $prevValue = $translation->value;
            $translation->value = $arguments['value'];
            $translation->save();
            $this->logSection('artconf', 'Zmieniono wartość pozycji ' . $arguments['position'] . ' dla języka ' . $arguments['lang'] . ': ' . $prevValue . ' --> ' . $arguments['value'], null, 'INFO');
          }
        } else {
          $this->logSection('artconf', 'Język ' . $arguments['lang'] . ' jest wyłączony w pliku YML lub nieużywany w serwisie', null, 'ERROR');
        }
      }
    } else {
      $this->logSection('artconf', 'Nie ma takiej pozycji w ArtConfiguration', null, 'ERROR');
    }
  }

}

?>
