<?php

class arteneoAddMissingTranslationsTask extends sfBaseTask {

  public function configure() {
    $this->namespace = 'arteneo';
    $this->name = 'add-missing-translations';
    $this->aliases = array("amt");
    $this->briefDescription = 'Uzupelnia brakujace wpisy w tabelach translacyjnych';
    $this->detailedDescription = <<<EOF
Task [arteneo:add-missing-translations|INFO] Uzupelnia brakujace wpisy w tabelach translacyjnych
  
Jesli podamy argument table (opcjonalny) to uzupelni nam translacje tylko w tej tabeli (podawana tabela musi miec templatke translacyjna)
  
  [./symfony arteneo:add-missing-translations Article]
 
  [./symfony arteneo:add-missing-translations|INFO]
EOF;
    $this->addArguments(array(
        new sfCommandArgument('table', sfCommandArgument::OPTIONAL, 'Nazwa tabeli translacyjnej', null),
    ));

    $this->addOptions(array(
        new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'doctrine'),
    ));
  }

  public function execute($arguments = array(), $options = array()) {
    sfApplicationConfiguration::getApplicationConfiguration('frontend', 'prod', true);
    $databaseManager = new sfDatabaseManager($this->configuration);
    $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

    // Jezyki
    $cultures = sfConfig::get('sf_cultures', array());
    $defaultCulture = sfConfig::get('sf_default_culture', 'pl');
    $cultureCount = count($cultures);

    if ($arguments['table'] && !Doctrine::isValidModelClass($arguments['table'])) {
      $this->logSection('add-missing-translations', 'Podana tabela "'.$arguments['table'].'" nie istnieje.', null, 'ERROR');
    } else {
      $tableNames = array();
      if ($arguments['table']) {
        $tableNames[] = $arguments['table'];
      } else {
        $modelDir = sfConfig::get('sf_lib_dir') . '/model/';
        Doctrine::loadModels($modelDir);
        $tableNames = Doctrine::getLoadedModels();
      }
      foreach ($tableNames as $tableName) {
        $count = 0;
        $table = Doctrine::getTable($tableName);
        if ($table->hasTemplate('I18n')) {
          $tableRecords = $table->createQuery('t')->leftJoin('t.Translation')->execute();
          $translationFields = $table->getTemplate('I18n')->getOption('fields');
          foreach ($tableRecords as $record) {
            if (count($record->Translation) < $cultureCount) {
              foreach ($cultures as $culture) {
                if (!isset($record->Translation[$culture])) {
                  // Dodajemy rekord
                  $count++;
                  $record->Translation[$culture]['id'] = $record->getId();
                  foreach ($translationFields as $field) {
                    if (isset($record->Translation[$defaultCulture])) {
                      $record->Translation[$culture][$field] = $this->getTranslationString($field, $culture, $record->Translation[$defaultCulture][$field]);
                    } else {
                      $record->Translation[$culture][$field] = $this->getTranslationString($field, $culture);
                    }
                  }
                  $record->Translation[$culture]['lang'] = $culture;
                }
              }

              $record->save();
            }
          }
          
          $this->logSection('amt', 'Do tabeli "'.$tableName.'Translation" dodano '.$count.' rekordów.');
        }
      }
      
      
    }
  }
  
  /**
   * Zwraca ciag znakow dla pola translacji na podstawie parametrow
   * @param string $field Nazwa pola
   * @param string $culture Jezyk
   * @param mixed $defaultCultureString Zawartosc pola w translacji domyslnego jezyka
   * @return string
   */
  protected function getTranslationString($field, $culture, $defaultCultureString = false) {
    if ($defaultCultureString === false) {
      return $culture.' '.$field;
    } else {
      if (is_null($defaultCultureString) || $defaultCultureString == '') {
        return $defaultCultureString;
      } else {      
        return $culture.' '.$defaultCultureString;
      }
    }
  }

}

?>
