<?php

/*
 * This file is part of the symfony package.
 * (c) 2004-2006 Fabien Potencier <fabien.potencier@symfony-project.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

//require_once(dirname(__FILE__).'/sfGeneratorBaseTask.class.php');

/**
 * Generates a new application.
 *
 * @package    symfony
 * @subpackage task
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 * @version    SVN: $Id: sfGenerateAppTask.class.php 24039 2009-11-16 17:52:14Z Kris.Wallsmith $
 */
class arteneoApplicationConfigurationTask extends sfGeneratorBaseTask
{
  /**
   * @see sfTask
   */
  protected function configure()
  {
    $this->addArguments(array(
      new sfCommandArgument('app', sfCommandArgument::REQUIRED, 'The application name'),
    ));

    $this->addOptions(array(
      new sfCommandOption('csrf-secret', null, sfCommandOption::PARAMETER_REQUIRED, 'Secret to use for CSRF protection', true),
    ));

    $this->namespace = 'arteneo';
    $this->name = 'application-configure';

    $this->briefDescription = 'Configures application';

    $this->detailedDescription = <<<EOF
TYLKO DO UZYTKU PREZ CREATOR CHYBA ZE WIESZ CO ROBISZ

Zamienia csrf_secret na nowy. Tylko gdy stary jest rowny UniqueSecret

  [./symfony arteneo:application-configure frontend --csrf-secret=true]

EOF;
  }

  /**
   * @see sfTask
   */
  protected function execute($arguments = array(), $options = array())
  {
    $app = $arguments['app'];

    // Validate the application name
    if (!preg_match('/^[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*$/', $app))
    {
      throw new sfCommandException(sprintf('The application name "%s" is invalid.', $app));
    }

    $appDir = sfConfig::get('sf_apps_dir').'/'.$app;

    if (!is_dir($appDir))
    {
      throw new sfCommandException(sprintf('The application "%s" does not exists.', $appDir));
    }

    $options['csrf-secret'] = sha1(rand(111111111, 99999999).getmypid());

    // Set no_script_name value in settings.yml for production environment
    $finder = sfFinder::type('file')->name('settings.yml');
    $this->getFilesystem()->replaceTokens($finder->in($appDir.'/config'), '', '', array(
      'UniqueSecret'       => sfYamlInline::dump(sfYamlInline::parseScalar($options['csrf-secret'])),
    ));

  }
}
