<?php
/**
 * Task który wykonuje kilka innych tasków.
 *  - doctrine:drop-db
 *  - doctrine:build-db
 *  - arteneo:build-model-filters-form
 *  - doctrine:build-sql
 *  - doctrine:insert-sql
 */
class arteneoBuildAllTask extends sfBaseTask
{
    /**
     * Konfiguracja.
     */
    protected function configure()
    {
        $this->namespace = 'arteneo';
        $this->name = 'build-all';
        $this->briefDescription = 'Uses doctrin:build --all --no-confirmation';
        $this->detailedDescription =
<<<EOF
The [arteneo:build-all|INFO] task does things.
Call it with:

[php symfony arteneo:build-all|INFO]
EOF;
    }

    /**
     * Wykonanie.
     *
     * @param array $arguments
     * @param array $options
     * @return int|void
     */
    protected function execute($arguments = array(), $options = array())
    {
        unset($arguments['task']);
        $this->runTask('doctrine:drop-db', '--no-confirmation');
        $this->runTask('doctrine:build-db');
        $this->runTask('arteneo:build-model-filters-form');
        $this->runTask('doctrine:build-sql');
        $this->runTask('doctrine:insert-sql');

    }
}
