<?php

class arteneoBuildModelFiltersFormTask extends sfBaseTask
{
    protected function configure()
    {
        $this->addOptions(array(
            new sfCommandOption('filter-generator-class', null, sfCommandOption::PARAMETER_REQUIRED, 'generator class', 'artDoctrineFormFilterGenerator'),
            new sfCommandOption('form-generator-class', null, sfCommandOption::PARAMETER_REQUIRED, 'generator class', 'artDoctrineFormGenerator')
        ));

        $this->namespace = 'arteneo';
        $this->name = 'build-model-filters-form';
        $this->briefDescription = 'Runs build-/model,filters,form/';
        $this->detailedDescription = <<<EOF
The [arteneo:build-model-filters-form|INFO] task does things.
Call it with:

  [php symfony arteneo:build-model-filters-form|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        try {
            $context = sfContext::getInstance();
        } catch (sfException $e) {
            $configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'dev', true);
            $context = sfContext::createInstance($configuration);
        }

        $this->runTask('doctrine:build-model');
        $this->runTask('doctrine:build-forms', array(), array('generator-class' => $options['form-generator-class']));
        $this->runTask('doctrine:build-filters', array(), array('generator-class' => $options['filter-generator-class']));
    }
}
