<?php

class arteneoDataLoadTask extends sfBaseTask
{
    protected $databaseManager;

    protected function configure()
    {
        $this->addOptions(array(
            new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
            new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'doctrine'),
            new sfCommandOption('without-first-echo', null, sfCommandOption::PARAMETER_NONE),
            new sfCommandOption('without-truncate', null, sfCommandOption::PARAMETER_NONE),
            // add your own options here
        ));

        $this->namespace = 'arteneo';
        $this->name = 'data-load';
        $this->briefDescription = 'Truncates every table in database, then dataload';
        $this->detailedDescription = <<<EOF
The [arteneo:data-load|INFO] task does things.
Call it with:

  [php symfony arteneo:data-load|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        $timeStart = microtime(true);

        if (!$options['without-first-echo'])
            echo "data-load\n";

        if (!$options['without-truncate'])
            $this->truncateTables($options);

        $this->runTask('doctrine:data-load', array(), array('append'));

        $timeEnd = microtime(true);
        $time = number_format($timeEnd - $timeStart, 2, '.', '');

        echo "\nCzas wypełniania bazy danych danymi - $time sekund \n";
    }

    protected function openDbConnection($options)
    {
        try {
            $this->databaseManager = new sfDatabaseManager($this->configuration);
            $connection = $this->databaseManager->getDatabase($options['connection'])->getConnection();
            $dbh = Doctrine_Manager::getInstance()->getCurrentConnection()->getDbh();

        } catch (sfDatabaseException $ex) {
            echo "Baza o podanej nazwie nie istnieje" . $ex;
        }

        return $dbh;
    }

    protected function closeDbConnection($dbh)
    {
        unset($dbh);
        $this->databaseManager->shutdown();
    }

    public function truncateTables($options = array())
    {
        $dbh = $this->openDbConnection($options);

        $tables = $dbh->query("SHOW FULL TABLES");

        foreach ($tables as $table)
            if ($table[1] != 'VIEW')
                $dbh->query('TRUNCATE TABLE ' . $table[0]);

        $this->closeDbConnection($dbh);
    }
}
