<?php

class arteneoDecryptdbTask extends sfBaseTask
{
    protected $key = 'TajnyKlucz';

    protected function configure()
    {
        $this->addOptions(array(
            new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
            new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'doctrine'),
        ));

        $this->namespace = 'arteneo';
        $this->name = 'decrypt-db';
        $this->briefDescription = 'Task decrypt-db pozwala na odkodowanie przy pomocy funkcji AES_DECRYPT() w MySQL danych aktualnie b�d�cych w bazie danych';
        $this->detailedDescription = <<<EOF
The [arteneo:decrypt-db|INFO] task does things.
Call it with:

  [php symfony arteneo:decrypt-db|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        $configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'dev', true);
        $context = sfContext::createInstance($configuration);
        // initialize the database connection
        $databaseManager = new sfDatabaseManager($this->configuration);
        $connection = $databaseManager->getDatabase($options['connection'])->getConnection();

        $modelDir = sfConfig::get('sf_lib_dir') . '/model/';
        Doctrine_Core::loadModels($modelDir);

        $loadedModels = Doctrine_Core::getLoadedModels();

        // Dodanie tabel translacyjnych
        $transTables = array();
        foreach ($loadedModels as $model) {
            if (Doctrine::getTable($model)->hasTemplate('I18n')) {
                $transTables[] = $model . 'Translation';
            }
        }
        $loadedModels = array_merge($loadedModels, $transTables);

        $this->key = Doctrine_Manager::getInstance()->getAttribute('encryptedKey');

        $conn = Doctrine_Manager::connection();

        foreach ($loadedModels as $model) {
            $sql = $this->buildDecryptUpdateSql($model);
            if ($sql != '')
                $pdo = $conn->execute($sql);
        }
    }

    protected function buildDecryptUpdateSql($model)
    {
        $sql = 'UPDATE `' . sfInflector::tableize($model) . '` SET ';
        $needUpdate = false;
        foreach (Doctrine::getTable($model)->getColumnNames() as $col) {
            $def = Doctrine::getTable($model)->getColumnDefinition($col);
            if (isset($def['encrypted']) && $def['encrypted'] == true) {
                $sql .= '`' . $col . '` = UNHEX(AES_DECRYPT(UNHEX(`' . $col . '`),\'' . $this->key . '\' )), ';
                $needUpdate = true;
            }
        }
        if ($needUpdate)
            return substr($sql, 0, -2);
        else
            return '';
    }
}
