<?php
require_once(sfConfig::get('sf_config_dir') . '/ProjectConfiguration.class.php');

class arteneoExecSqlTask extends sfBaseTask
{

    private $dbHostName;
    private $dbName;
    private $dbUsername;
    private $dbPassword;
    private $sqlsArray = array();

    protected function configure()
    {
        $this->addOptions(array(
            new sfCommandOption('application', null, sfCommandOption::PARAMETER_REQUIRED, 'The application name'),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
            new sfCommandOption('connection', null, sfCommandOption::PARAMETER_REQUIRED, 'The connection name', 'doctrine'),
        ));

        $this->namespace = 'arteneo';
        $this->name = 'exec-sql';
        $this->briefDescription = 'Loads and runs sql queries from data/sql';
        $this->detailedDescription = <<<EOF
Call it without parameters
  [php symfony arteneo:exec-sql|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        echo "exec-sql\n";

        $configuration = ProjectConfiguration::getApplicationConfiguration('frontend', 'dev', true);

        $dirs = $configuration->getPluginSubPaths('/data/sql/');
        $dirs[] = sfConfig::get('sf_data_dir') . '/sql/';
        $dirs[] = sfConfig::get('sf_data_dir') . '/sql-log/';

        foreach ($dirs as $dir)
            if (is_dir($dir))
                $this->processDir($dir);

        $this->execSqls();
    }

    private function processDir($dir)
    {
        $handle = opendir($dir);

        while ($file = readdir($handle))
            if (artString::endsWith('.sql', $file) && !artString::startsWith('schema', $file))
                $this->sqlsArray[$file] = $dir . $file;
    }

    private function execSqls()
    {
        ksort($this->sqlsArray);
        $this->loadDatabaseConfig();

        foreach ($this->sqlsArray as $sql) {
            echo $sql . " \n";
            passthru('mysql -p' . $this->dbPassword . ' -u ' . $this->dbUsername . ' -h ' . $this->dbHostName . ' ' . $this->dbName . ' <' . $sql);
        }
    }

    private function parseDatabaseName($dsn)
    {
        $semicolons = explode(';', $dsn);

        foreach ($semicolons as $semicolon)
            $equals[] = explode('=', $semicolon);

        $this->dbHostName = $equals[0][1];
        $this->dbName = $equals[1][1];
    }

    private function loadDatabaseConfig()
    {
        $file = sfConfig::get('sf_config_dir') . '/databases.yml';
        $config = file_exists($file) ? sfYaml::load($file) : array();
        $db_params = $config['all']['doctrine']['param'];

        $this->parseDatabaseName($db_params['dsn']);
        $this->dbUsername = $db_params['username'];
        $this->dbPassword = $db_params['password'];
    }

}