<?php

class arteneoGenerateDbTask extends sfBaseTask
{
    protected function configure()
    {
        $this->addOptions(array(
            new sfCommandOption('without-dataload', null, sfCommandOption::PARAMETER_NONE,
                'Do not load fixtures'),
            new sfCommandOption('without-sql', null, sfCommandOption::PARAMETER_NONE,
                'Do not load sql-files')
        ));

        $this->namespace = 'arteneo';
        $this->name = 'generate-db';
        $this->briefDescription = 'Runs arteneo:build-all, data-load and exec-sql ';
        $this->detailedDescription = <<<EOF
The [arteneo:generate-db|INFO] task does things.
Call it with:

  [php symfony arteneo:generate-db|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        $timeStart = microtime(true);

        $logArray = SchemaConfig::getLogTables();
        $this->runTask('doctrine:clean-model-files', array(), array('no-confirmation'));

        if (!empty($logArray))
            $this->runTask('arteneo:generate-log-db', array(), array(
                'without-dataload' => $options['without-dataload'],
                'without-sql' => $options['without-sql']
            ));

        else {
            $this->runTask('arteneo:build-all');

//      $this->runTask('arteneo:truncate-tables');

            $this->runTask('arteneo:exec-pre-sql');

            if (!$options['without-dataload'])
                $this->runTask('arteneo:data-load', array(), array('without-truncate'));

            if (!$options['without-sql'])
                $this->runTask('arteneo:exec-sql');
        }

        $timeEnd = microtime(true);
        $time = number_format($timeEnd - $timeStart, 2, '.', '');

        echo "\nCzas tworzenia bazy danych - $time sekund \n";
    }
}
