<?php

class arteneoGenerateMatrixTask extends sfBaseTask
{
    protected function configure()
    {

        $this->namespace = 'arteneo';
        $this->name = 'generate-matrix';
        $this->briefDescription = 'Generates admin matrix';

        $this->addArguments(array(
            new sfCommandArgument('application', sfCommandArgument::REQUIRED, 'The application name'),
            new sfCommandArgument('route_or_model', sfCommandArgument::REQUIRED, 'The route name or the model class'),
        ));

        $this->addOptions(array(
            new sfCommandOption('module', null, sfCommandOption::PARAMETER_REQUIRED, 'The module name', null),
            new sfCommandOption('theme', null, sfCommandOption::PARAMETER_REQUIRED, 'The theme name', 'matrix'),
            new sfCommandOption('singular', null, sfCommandOption::PARAMETER_REQUIRED, 'The singular name', null),
            new sfCommandOption('plural', null, sfCommandOption::PARAMETER_REQUIRED, 'The plural name', null),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
            new sfCommandOption('actions-base-class', null, sfCommandOption::PARAMETER_REQUIRED, 'The base class for the actions', 'artActions'),
            new sfCommandOption('routing-class', null, sfCommandOption::PARAMETER_REQUIRED, 'The routing class name', 'artMatrixDoctrineRouteCollection'),
        ));

        $this->detailedDescription = <<<EOF
The [arteneo:generate-matrix|INFO] task does things.
Call it with:

  [php symfony arteneo:generate-matrix|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        unset($arguments['task']);
        if (isset($options['module']))
            $this->runTask('arteneo:generate-admin', $arguments, $options);
        else {
            $moduleName = 'matrix_' . sfInflector::underscore($arguments['route_or_model']);
            $this->runTask('arteneo:generate-admin', $arguments,
                array_merge($options, array('module' => $moduleName)));
        }
    }
}
