<?php

class arteneoGenerateReportMatrixTask extends sfBaseTask
{
    protected function configure()
    {
        $this->addArguments(array(
            new sfCommandArgument('application', sfCommandArgument::REQUIRED, 'The application name'),
            new sfCommandArgument('route_or_model', sfCommandArgument::REQUIRED,
                'The route name or the model class')
        ));

        $this->addOptions(array(
            new sfCommandOption('module', null, sfCommandOption::PARAMETER_OPTIONAL,
                'The module name', null),
            new sfCommandOption('routing-class', null, sfCommandOption::PARAMETER_REQUIRED,
                'The routing class name', 'artChartDoctrineRouteCollection'),
            new sfCommandOption('theme', null, sfCommandOption::PARAMETER_REQUIRED,
                'The theme name', 'reportmatrix'),
        ));

        $this->namespace = 'arteneo';
        $this->name = 'generate-report-matrix';
        $this->briefDescription = '';
        $this->detailedDescription = <<<EOF
The [arteneo:generate-report-matrix|INFO] task does things.
Call it with:

  [php symfony arteneo:generate-report-matrix|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        $this->runTask('arteneo:build-model-filters-form');
        unset($arguments['task']);

        if (isset($options['module'])) {
            $this->runTask('arteneo:generate-admin', $arguments, $options);
            $moduleName = $options['module'];
        } else {
            $moduleName = 'report_matrix_' . sfInflector::underscore($arguments['route_or_model']);

            $this->runTask('arteneo:generate-admin', $arguments,
                array_merge($options, array('module' => $moduleName)));
        }
    }
}
