<?php

class arteneoGenerateReportTask extends sfBaseTask
{
    protected function configure()
    {

        $this->namespace = 'arteneo';
        $this->name = 'generate-report';
        $this->briefDescription = 'Generates admin report';

        $this->addArguments(array(
            new sfCommandArgument('application', sfCommandArgument::REQUIRED, 'The application name'),
            new sfCommandArgument('route_or_model', sfCommandArgument::REQUIRED, 'The route name or the model class'),
        ));

        $this->addOptions(array(
            new sfCommandOption('module', null, sfCommandOption::PARAMETER_OPTIONAL, 'The module name', null),
            new sfCommandOption('theme', null, sfCommandOption::PARAMETER_REQUIRED, 'The theme name', 'report'),
            new sfCommandOption('singular', null, sfCommandOption::PARAMETER_REQUIRED, 'The singular name', null),
            new sfCommandOption('plural', null, sfCommandOption::PARAMETER_REQUIRED, 'The plural name', null),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
            new sfCommandOption('actions-base-class', null, sfCommandOption::PARAMETER_REQUIRED, 'The base class for the actions', 'artActions'),
            new sfCommandOption('routing-class', null, sfCommandOption::PARAMETER_OPTIONAL, 'The routing class name', 'artChartDoctrineRouteCollection'),
        ));

        $this->detailedDescription = <<<EOF
The [arteneo:generate-report|INFO] task does things.
Call it with:

  [php symfony arteneo:generate-report|INFO]
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        unset($arguments['task']);
        if (isset($options['module']))
            $this->runTask('arteneo:generate-admin', $arguments, $options);
        else {
            $moduleName = 'report_' . sfInflector::underscore($arguments['route_or_model']);
            $this->runTask('arteneo:generate-admin', $arguments,
                array_merge($options, array('module' => $moduleName)));
        }

    }
}
