<?php
/**
 * Description of artUser
 */
class arteneoThemeGeneratorTask extends sfDoctrineGenerateAdminTask
{
    protected function configure()
    {
        $this->namespace = 'arteneo';
        $this->name = 'generate-admin';
        $this->briefDescription = 'Generate admin arteneotheme';

        $this->addArguments(array(
            new sfCommandArgument('application', sfCommandArgument::REQUIRED, 'The application name'),
            new sfCommandArgument('route_or_model', sfCommandArgument::REQUIRED, 'The route name or the model class'),
        ));

        $this->addOptions(array(
            new sfCommandOption('module', null, sfCommandOption::PARAMETER_REQUIRED, 'The module name', null),
            new sfCommandOption('theme', null, sfCommandOption::PARAMETER_REQUIRED, 'The theme name', 'arteneotheme'),
            new sfCommandOption('routing-class', null, sfCommandOption::PARAMETER_REQUIRED, 'The routing class name', 'artDoctrineRouteCollection'),
            new sfCommandOption('singular', null, sfCommandOption::PARAMETER_REQUIRED, 'The singular name', null),
            new sfCommandOption('plural', null, sfCommandOption::PARAMETER_REQUIRED, 'The plural name', null),
            new sfCommandOption('env', null, sfCommandOption::PARAMETER_REQUIRED, 'The environment', 'dev'),
            new sfCommandOption('actions-base-class', null, sfCommandOption::PARAMETER_REQUIRED, 'The base class for the actions', 'artActions')
        ));

        $this->detailedDescription = <<<EOF
The [arteneo:generate-admin|INFO] task generates a Doctrine admin module:

  [./symfony arteneo:generate-admin frontend Article|INFO]

The task creates a module in the [%frontend%|COMMENT] application for the
[%Article%|COMMENT] model.

The task creates a route for you in the application [routing.yml|COMMENT].

You can also generate a Doctrine admin module by passing a route name:

  [./symfony arteneo:generate-admin frontend article|INFO]

The task creates a module in the [%frontend%|COMMENT] application for the
[%article%|COMMENT] route definition found in [routing.yml|COMMENT].

For the filters and batch actions to work properly, you need to add
the [with_wildcard_routes|COMMENT] option to the route:

  article:
    class: sfDoctrineRouteCollectionar
    options:
      model:                Article
      with_wildcard_routes: true
EOF;
    }

    protected function execute($arguments = array(), $options = array())
    {
        $configuration = ProjectConfiguration::getApplicationConfiguration($arguments['application'], $options['env'], true);
        $context = sfContext::createInstance($configuration);

        // get configuration for the given route
        if (false !== ($route = $this->getRouteFromName($arguments['route_or_model']))) {
            $arguments['route'] = $route;
            $arguments['route_name'] = $arguments['route_or_model'];

            return $this->generateForRoute($arguments, $options);
        }

        // is it a model class name
        if (!class_exists($arguments['route_or_model'])) {
            throw new sfCommandException(sprintf('The route "%s" does not exist and there is no "%s" class.', $arguments['route_or_model'], $arguments['route_or_model']));
        }

        $r = new ReflectionClass($arguments['route_or_model']);
        if (!$r->isSubclassOf('Doctrine_Record')) {
            throw new sfCommandException(sprintf('"%s" is not a Doctrine class.', $arguments['route_or_model']));
        }

        // create a route
        $model = $arguments['route_or_model'];
        $name = strtolower(preg_replace(array('/([A-Z]+)([A-Z][a-z])/', '/([a-z\d])([A-Z])/'), '\\1_\\2', $model));

        if (isset($options['module'])) {
            $name = $options['module'];
            if (strpos($name, '-') !== false)
                throw new sfCommandException(sprintf('Module name cannot have this characters: - '));
//      $route = $this->getRouteFromName($name);
//      if ($route && !$this->checkRoute($route, $model, $options['module']))
//      {
//        $name .= '_'.$options['module'];
//      }
        }

        $routing = sfConfig::get('sf_app_config_dir') . '/routing.yml';
        $content = file_get_contents($routing);
        $routesArray = sfYaml::load($content);

        if (!isset($routesArray[$name])) {
            $databaseManager = new sfDatabaseManager($this->configuration);
            $primaryKey = Doctrine_Core::getTable($model)->getIdentifier();
            $module = $options['module'] ? $options['module'] : $name;
            $content = sprintf(<<<EOF
%s:
  class: %s
  options:
    model:                %s
    module:               %s
    prefix_path:          /%s
    column:               %s
    with_wildcard_routes: true


EOF
                , $name, $options['routing-class'], $model, $module, isset($options['plural']) ? $options['plural'] : $module, $primaryKey) . $content;

            $this->logSection('file+', $routing);

            if (false === file_put_contents($routing, $content)) {
                throw new sfCommandException(sprintf('Unable to write to file, %s.', $routing));
            }
        }

        $arguments['route'] = $this->getRouteFromName($name);
        $arguments['route_name'] = $name;

        return $this->generateForRoute($arguments, $options);
    }
}
