<?php

class artGuardSecurityUser extends sfGuardSecurityUser {

  public function __call($method, $arguments) {
    $lcMethod = strtolower($method);

    if (substr($lcMethod, 0, 2) == 'is') {
      $credential = substr($method, 2, strlen($method));
      return $this->hasPermission($credential);
    }

    throw new Exception(sprintf('Unknown method %s::%s', get_class($this), $method));
  }

  public function getId() {
    return $this->getAttribute('user_id', null, 'sfGuardSecurityUser');
  }

  public function hasCredential($credentials, $useAnd = true) {
    return (parent::hasCredential($credentials, $useAnd) && self::hasPermission($credentials, $useAnd));
  }

  public function hasPermission($permissions, $useAnd = true) {
    if (!is_array($permissions))
      return parent::hasPermission($permissions);

    // now we assume that $permissions is an array
    $test = false;

    foreach ($permissions as $permission) {
      // recursively check the permission with a switched AND/OR mode
      $test = self::hasPermission($permission, $useAnd ? false : true);

      if ($useAnd)
        $test = $test ? false : true;

      if ($test) // either passed one in OR mode or failed one in AND mode
        break; // the matter is settled
    }

    if ($useAnd) // in AND mode we succeed if $test is false
      $test = $test ? false : true;

    return $test;
  }

  public function setNotice($value, $noticeVars = array()) {
    $this->setFlash('notice', $value);
    $this->setFlash('notice_vars', $noticeVars);
  }

  public function forwardNotice() {
    if ($this->hasFlash('notice')) {
      $this->forwardFlash('notice');
      $this->forwardFlash('notice_vars');
    }
  }

  public function setError($value, $errorVars = array()) {
    $this->setFlash('error', $value);
    $this->setFlash('error_vars', $errorVars);
  }

  public function forwardError() {
    if ($this->hasFlash('error')) {
      $this->forwardFlash('error');
      $this->forwardFlash('error_vars');
    }
  }

  public function forwardFlash($name) {
    $this->setFlash($name, $this->getFlash($name));
  }

  public function signOut() {
    $this->attributeHolder->clear();
    parent::signOut();
  }

  public function signIn($user, $remember = false, $con = null) {
    parent::signIn($user, $remember, $con);

    UserMessageSetting::updateUserMessageSettings($this->getId());

    if (artSettings::checkPluginAvailibilty('artShopPlugin'))
      ShoppingCart::verifyCarts();
  }

  /**
   * Czy uzytkownik posiada prawa arteneo
   * @return boolean
   */
  public function isArteneo() {
    return $this->hasCredential('arteneo');
  }

  public function isAdmin() {
    return $this->hasCredential('admin') || $this->isArteneo();
  }

  public function isTranslator() {
    return $this->hasCredential('translation_edit') || $this->isAdmin();
  }

  /** Frontend Management * */

  /**
   * Funkcja sprawdza czy uzytkownik bedzie widzial podany w parametrze link.
   * Linki dostepne w FM to:
   * 'article_add', 'article_edit', 'article_meta_edit', 'article_gallery', 'article_delete',
   * 'category_add', 'category_edit', 'category_delete'
   * 'reference_add', 'reference_edit', 'reference_delete'
   * Oraz z pluginu tlumaczen:
   * 'translation_edit'
   *
   * @param string $link
   * @return string
   */
  public function hasFmLink($link) {
    return (sfConfig::get('app_fm_enabled', false) && $this->hasPermission(array('admin', $link), false));
  }

  /**
   * Funkcja sprawdza czy funkcja hasFmLink() zwroci co najmniej jeden TRUE
   * dla podanej tablicy linkow
   *
   * @param array $links
   * @return boolean
   */
  public function hasAnyFmLink($links) {
    foreach ($links as $link) {
      if ($this->hasFmLink($link)) {
        return true;
      }
    }

    return false;
  }

  /** KONIEC - Frontend Management * */

  /**
   *
   * @return bool
   */
  public function hasInlineEdit() {

    if ($this->isAdmin() && sfConfig::get('app_art_cms_plugin_inline_enabled', false)) {
      return true;
    } else {
      return false;
    }
  }

  /**
   * @return string
   */
  public function inlineEdit() {

    if ($this->hasInlineEdit()) {
      return ' contenteditable=true role=textbox ';
    }
  }

}
