<?php
/**
 * Description of sfArtValidatedFile
 *
 
 */
class sfArtValidatedFile extends sfValidatedFile
{
    public
      $originalName = '',
      $tempName     = '',
      $savedName    = null,
      $type         = '',
      $size         = 0,
      $path         = null,
      $newName = null,
      $resizes = array(),
      $resizeCenter = '',
      $imageMagickCommand = false;

    public function setNewName($newName = null)
    {
        $this->newName = $newName;
    }

    public function setResizeSize($width = null, $height = null)
    {
        $this->resizes['width'] = $width;
        $this->resizes['height'] = $height;
    }

    public function setResizeCenter($resizeCenter = false)
    {
        if ($resizeCenter)
            $this->resizeCenter = ' -gravity center';
    }

    public function generateFilename()
    {
        if (is_null($this->newName))
            return parent::generateFilename();
        else {
            $filename = $this->newName . $this->getExtension($this->getOriginalExtension());

            if (file_exists($this->path . DIRECTORY_SEPARATOR . $filename))
                $filename = $this->newName . rand(0, 10) . $this->getExtension($this->getOriginalExtension());

            return $filename;
        }
    }

    public function save($file = null, $fileMode = 0666, $create = true, $dirMode = 0777)
    {
        if ($this->imageMagickCommand !== false) {
            artEscaper::setDefaultInArray($this->resizes, 'width', 0);
            artEscaper::setDefaultInArray($this->resizes, 'height', 0);
        }

        if (isset($this->resizes['width'])) {
            $sizes = $this->resizes['width'] . "x" . $this->resizes['height'];

            if ($this->imageMagickCommand === false) {
                $newName = $this->tempName;

                $plugins = sfContext::getInstance()->getConfiguration()->getPlugins();
                if (in_array('sfImageTransformPlugin', $plugins)) {
                    $img = new sfImage($this->tempName);

                    if ($resizeCenter)
                        $img->thumbnail($this->resizes['width'], $this->resizes['height']);
                    else
                        $img->thumbnail($this->resizes['width'], $this->resizes['height'], 'center');

                    $img->saveAs($newName);
                } else {
                    if ($this->resizeCenter)
                        passthru("convert $this->tempName -resize " . $this->resizes['width'] . "x" . $this->resizes['height'] . "^ -gravity center -extent " . $this->resizes['width'] . "x" . $this->resizes['height'] . " $newName");
                    else
                        passthru("convert $this->tempName -thumbnail " . $this->resizes['width'] . "x" . $this->resizes['height'] . " $newName");
                }
                $this->tempName = $newName;
            } else {
                $replaces = array(
                    '%original%' => $this->tempName,
                    '%new%' => $this->tempName,
                    '%width%' => $this->resizes['width'],
                    '%height%' => $this->resizes['height'],
                    '%sizes%' => $sizes
                );

                $command = str_replace(array_keys($replaces), array_values($replaces), $this->imageMagickCommand);
                passthru($command);
            }
        }

        return parent::save($file, $fileMode, $create, $dirMode);
    }

    public function setImageMagickCommand($command)
    {
        $this->imageMagickCommand = $command;
    }

}
