<?php

/**
 * Description of sfArtValidatorChartBlacklist
 *
 
 */
class sfArtValidatorCharBlacklist extends sfValidatorString
{
  public function __construct($options = array(), $messages = array())
  {
    $this->addOption('blacklist', '!@#$%^&*()_+|\\/?>.<,~`\'":;0123456789');
    $this->addMessage('in_blacklist', 'Wartość zawiera co najmniej jeden z zakazanych znaków: "%blacklist%".');
    
    parent::__construct($options, $messages);
  }
  
  protected function doClean($value)
  {
    $clean = parent::doClean($value);
    $matches = array();
    $blacklist = $this->getOption('blacklist');
    
    for ($i = 0; $i < strlen($clean); $i++)
      if (strpos($blacklist, $clean{$i}) !== false)
        throw new sfValidatorError($this, 'in_blacklist', array('blacklist' => $blacklist));
    
    return $clean;
  }
}
