<?php

class sfArtValidatorDate extends sfValidatorDate
{
  
  public function __construct($options = array(), $messages = array())
  {
    if (isset($options['min_year']))
    {
      $options['min'] = artDate::getYearBefore(date("Y") - $options['min_year']);
      unset($options['min_year']);
    }
    
    if (isset($options['max_year']))
    {
      $options['max'] = artDate::getYearBefore(date("Y") - $options['max_year']);
      unset($options['max_year']);
    }
    
    if (isset($options['dates_format']))
    {
      $options['date_format_range_error'] = $options['dates_format'];
      $options['date_format_error'] = $options['dates_format'];
      unset($options['dates_format']);
    }
    
    parent::__construct($options, $messages);
  }

}
