<?php

/**
 * Description of sfArtValidatorEmailExistsInDatabase
 *
 
 */
class sfArtValidatorEmailExistsInDatabase extends sfValidatorEmail
{
    /**
     * @param array $options
     * @param array $messages
     */
    public function configure($options = array(), $messages = array())
    {
        parent::configure($options, $messages);

        $this->addMessage('not_exists', 'Podany adres email nie istnieje w naszej bazie danych.');
    }

    /**
     * @param mixed $value
     * @return mixed|string
     * @throws sfValidatorError
     */
    protected function doClean($value)
    {
        $clean = parent::doClean($value);
        $pattern = $this->getPattern();

        if (
            ($this->getOption('must_match') && !preg_match($pattern, $clean))
            ||
            (!$this->getOption('must_match') && preg_match($pattern, $clean))
        ) {
            throw new sfValidatorError($this, 'invalid', array('value' => $value));
        }

        if (!Doctrine::getTable('sfGuardUser')->findOneByEmailAddress($clean))
            throw new sfValidatorError($this, 'not_exists');

        return $clean;
    }
}
