<?php
/**
 * Description of sfArtValidatorEmailsTable
 *
 
 */
class sfArtValidatorEmailsTable extends sfValidatorBase
{
    /**
     * @param array $options
     * @param array $messages
     */
    protected function configure($options = array(), $messages = array())
    {
        $this->addMessage('not_array', 'To nie jest tablica');
        $this->addMessage('invited', '');
        $this->addMessage('invite_yourself', '');
        $this->addMessage('has_account', '');
        $this->addMessage('empty_value', 'Nie należy umieszczać pustych wartości');
        $this->addOption('not_array');
        $this->setOption('empty_value', '');
    }

    /**
     * @param mixed $value
     * @return mixed
     * @throws sfValidatorError
     */
    public function doClean($value)
    {
        $emptyInputs = array();
        $invalidInputs = array();
        $invitedInputs = array();
        $inviteYourself = array();
        $hasAccountsInputs = array();

        $sessionUser = sfContext::getInstance()->getUser();

        foreach ($value as $i => $valueElement) {
            if ($valueElement == '')
                $emptyInputs[] = $i;
            else if (!preg_match('/^([^@\s]+)@((?:[-a-z0-9]+\.)+[a-z]{2,})$/i', $valueElement))
                $invalidInputs[] = $i;
            else if ($valueElement === $sessionUser->getGuardUser()->getEmailAddress())
                $inviteYourself[] = $i;
            else if (Doctrine::getTable('sfGuardUser')->findOneByEmailAddress($valueElement))
                $hasAccountsInputs[] = $i;
            else if (Doctrine::getTable('Invitation')->findOneByEmail($valueElement))
                $invitedInputs[] = $i;
        }

        sfConfig::set('emptyInputs', $emptyInputs);
        sfConfig::set('invalidInputs', $invalidInputs);
        sfConfig::set('invitedInputs', $invitedInputs);
        sfConfig::set('inviteYourself', $inviteYourself);
        sfConfig::set('hasAccountsInputs', $hasAccountsInputs);


        $emptyValue = $this->getOption('empty_value');

        if (!empty($emptyInputs))
            throw new sfValidatorError($this, 'required', array('value' => $value, 'empty_value' => $emptyValue));

        if (!empty($invalidInputs))
            throw new sfValidatorError($this, 'invalid', array('empty_value' => $emptyValue));

        if (!empty($invitedInputs))
            throw new sfValidatorError($this, 'invited', array('empty_value' => $emptyValue));

        if (!empty($inviteYourself))
            throw new sfValidatorError($this, 'invite_yourself', array('empty_value' => $emptyValue));

        if (!empty($hasAccountsInputs))
            throw new sfValidatorError($this, 'has_account', array('empty_value' => $emptyValue));

        return $value;
    }

}
