<?php

/**
 * Description of sfArtValidatorFile
 *
 
 */
class sfArtValidatorFile extends sfValidatorFile
{
    /**
     * @param array $options
     * @param array $messages
     */
    public function __construct($options = array(), $messages = array())
    {
        parent::__construct($options, $messages);

        if (is_null($this->getOption('mime_types')))
            $this->options['mime_types'] = $this->options['mime_categories']['web_images'];
    }

    /**
     * @param array $options
     * @param array $messages
     */
    public function configure($options = array(), $messages = array())
    {
        parent::configure($options, $messages);

        if ($this->getOption('validated_file_class') == 'sfValidatedFile')
            $this->setOption('validated_file_class', 'sfArtValidatedFile');

        $this->addOption('image_magick_command', false);

        $this->addOption('new_name', null);
        $this->addOption('resize_size', null);
        $this->addOption('resize_size_width', null);
        $this->addOption('resize_size_height', null);
        $this->addOption('resize_center', false);
        //false zmniejsza zdjęcie do podanego rozmaiaru i zostawia wolne miejsca
        //true zmniejsza zdjęcie do podanego rozmiaru odcinając obrazek wykraczający poza obszar
    }

    /**
     * @param mixed $value
     * @return mixed|sfArtValidatedFile
     */
    protected function doClean($value)
    {
        $validatedFileClass = parent::doClean($value);

        if ($validatedFileClass instanceof sfArtValidatedFile) {
            $validatedFileClass->setNewName($this->getOption('new_name'));
            $imageMagickCommand = $this->getOption('image_magick_command');

            if ($imageMagickCommand !== false)
                $validatedFileClass->setImageMagickCommand($imageMagickCommand);

            $resizeSize = $this->getOption('resize_size');

            if (!is_null($resizeSize))
                $validatedFileClass->setResizeSize($resizeSize, $resizeSize);
            else
                $validatedFileClass->setResizeSize($this->getOption('resize_size_width'), $this->getOption('resize_size_height'));

            $validatedFileClass->setResizeCenter($this->getOption('resize_center'));
        }

        return $validatedFileClass;
    }

    /**
     * @param $name
     */
    public function setNewName($name)
    {
        $this->setOption('new_name', $name);
    }
}
