<?php
/**
 * Validator for Nip
 */
class sfArtValidatorNip extends sfValidatorBase
{

    /**
     * @param array $options
     * @param array $messages
     */
    protected function configure($options = array(), $messages = array())
    {
        parent::configure($options, $messages);

        $this->addMessage('bad_length', 'Długość Numeru NIP to 13 znaków (z myślnikami) lub 10 znaków (bez myślników).');
        $this->setMessage('invalid', 'Twój NIP: "%nip%" jest niepoprawny.');
        $this->addMessage('bad_format', 'Twój NIP: "%nip%" posiada niedozwolone znaki.');
    }

    /**
     * @param mixed $value
     * @return mixed|string
     * @throws sfValidatorError
     */
    protected function doClean($value)
    {
        if (!preg_match('/^[0-9 \-]+$/i', $value))
            throw new sfValidatorError($this, 'bad_format', array('nip' => $value));

        $inputValue = $value;
        $value = str_replace(array('-', ' '), '', $value);
        $length = function_exists('mb_strlen') ? mb_strlen($value, $this->getCharset()) : strlen($value);
        $inputLength = function_exists('mb_strlen') ? mb_strlen($inputValue, $this->getCharset()) : strlen($inputValue);

        if ($inputLength < 10 || $inputLength > 13 || $length != 10)
            throw new sfValidatorError($this, 'bad_length');

        if (!$this->isNip($value))
            throw new sfValidatorError($this, 'invalid', array('nip' => $value));

        $returnValue = substr($value, 0, 3) . '-' . substr($value, 3, 3) . '-' . substr($value, 6, 2) . '-' . substr($value, 8, 2);

        return $returnValue;
    }

    /**
     * @param $nip
     * @return bool
     */
    function isNip($nip)
    {
        if ($nip == 0 || !is_numeric($nip))
            return false;

        $weights = array(6, 5, 7, 2, 3, 4, 5, 6, 7);
        $digits = str_split($nip);
        $digits_length = count($digits);

        for ($i = 1; $i < count($digits); $i++) {
            if ($digits[0] != $digits[$i])
                break;
            if ($digits[0] == $digits[$i] && $i == $digits_length - 1)
                return false;
        }

        $in_control_number = intval(array_pop($digits));
        $sum = 0;
        $weights_length = count($weights);

        for ($i = 0; $i < $weights_length; $i++)
            $sum += $weights[$i] * intval($digits[$i]);

        $modulo = $sum % 11;

        //$control_number = ($modulo == 10) ? 0 : $modulo;
        $control_number = $modulo;

        if ($modulo == 10)
            return false;

        return $in_control_number == $control_number;
    }
}