<?php

/**
 * Description of sfArtValidatorNumberCommaFixed
 *
 
 */
class sfArtValidatorNumberComaFixed extends sfArtValidatorNumber
{
    protected $afterComa;

    protected function configure($options = array(), $messages = array())
    {
        parent::configure($options, $messages);

        $this->addOption('digit_after_coma', 2);

        //jeżeli false, to sprawdza, czy po przecinku jest równo tyle liczb, co w digit_after_coma;
        //jeżeli true, to sprawdza, czy maksymalnie tyle jest podanych
        $this->addOption('max_digit_after_coma', false);

        $this->addMessage('digits_after_coma', 'Wartość pola "%field_name%" powinna posiadać %digits% miejsca po przecinku.');
        $this->addMessage('digit_after_coma', 'Wartość pola "%field_name%" powinna posiadać %digit% miejsce po przecinku.');
        $this->addMessage('max_digits_after_coma', 'Wartość pola "%field_name%" powinna posiadać maksymalnie %digits% miejsca po przecinku.');
        $this->addMessage('max_digit_after_coma', 'Wartość pola "%field_name%" powinna posiadać maksymalnie %digit% miejsce po przecinku.');
    }

    protected function doClean($value)
    {
        $clean = parent::doClean($value);
        $digitsAfterComa = $this->getOption('digit_after_coma');

        if (strpos($value, '.'))
            $afterComa = explode('.', $value);
        else
            $afterComa = explode(',', $value);

        $this->afterComa = isset($afterComa[1]) ? $afterComa[1] : '';
        $maxDigitAfterComa = $this->getOption('max_digit_after_coma');

        if ($digitsAfterComa !== false) {

            if ($maxDigitAfterComa) {
                $validatorErrorPrefix = 'max_';
                $condition = strlen($this->afterComa) > $digitsAfterComa;
            } else {
                $validatorErrorPrefix = '';
                $condition = strlen($this->afterComa) != $digitsAfterComa;
            }

            if ($condition || (count($afterComa) == 1 && !$maxDigitAfterComa)) {
                if ($digitsAfterComa == 1)
                    throw new sfValidatorError($this, $validatorErrorPrefix . 'digit_after_coma', array('field_name' => $this->getOption('field_name'), 'digit' => $digitsAfterComa));
                else
                    throw new sfValidatorError($this, $validatorErrorPrefix . 'digits_after_coma', array('field_name' => $this->getOption('field_name'), 'digits' => $digitsAfterComa));
            }
        }

        if ($digitsAfterComa)
            $clean = number_format($clean, 2, '.', '');

        return $clean;
    }

}
