<?php
/**
 * Description of sfArtValidatorWwww
 *
 
 */

class sfArtValidatorWww extends sfValidatorRegex
{
    /**
     * @param array $options
     * @param array $messages
     */
    public function configure($options = array(), $messages = array())
    {
        parent::configure($options, $messages);

        $this->requiredOptions = array();

        $this->addOption('pattern', '|^http(s)?://[a-z0-9-_]+(\.[a-z0-9-_]+)+(:[0-9]+)?(/.*)?$|i');
    }

    /**
     * @param mixed $value
     * @return mixed|string
     */
    protected function doClean($value)
    {
        if (!artString::startsWith('http', $value))
            $value = 'http://' . $value;

        return parent::doClean($value);
    }
}
