<?php
/**
 * Description of sfArtValidatorZipCode
 *
 
 */
class sfArtValidatorZipCode extends sfValidatorBase
{

    /**
     * @param array $options
     * @param array $messages
     */
    protected function configure($options = array(), $messages = array())
    {
        parent::configure($options, $messages);

        $this->addMessage('bad_format', 'Zły format.');
    }

    /**
     * @param mixed $value
     * @return mixed|string
     * @throws sfValidatorError
     */
    protected function doClean($value)
    {
        $pattern = '/^[0-9]{2}[-]{0,1}[0-9]{3}$/i';

        if (!preg_match($pattern, $value))
            throw new sfValidatorError($this, 'bad_format', array('value' => $value));

        if (strpos($value, '-') === false)
            $value = substr($value, 0, 2) . '-' . substr($value, 2);

        return $value;
    }

}
