<?php

/**
 * Description of artPHPView
 *
 
 */
class artPHPView extends sfPHPView
{
    /**
     *
     */
    public function configure()
    {
        // store our current view
        $this->context->set('view_instance', $this);

        // require our configuration
        require($this->context->getConfigCache()->checkConfig('modules/' . $this->moduleName . '/config/view.yml'));

        if (strpos($this->viewName, '/') !== false) {
            $tempArray = explode('/', $this->viewName);
            $this->moduleName = current($tempArray);
            $this->setTemplate(end($tempArray) . $this->getExtension());
            $this->setDirectory($this->context->getConfiguration()->getTemplateDir($this->moduleName, $this->getTemplate()));
        }

        if (!$this->directory)
            $this->setDirectory($this->context->getConfiguration()->getTemplateDir($this->moduleName, $this->getTemplate()));
    }

    /**
     * @return mixed
     */
    public function getAttributes()
    {
        return $this->getAttributeHolder()->getAll();
    }

    /**
     *
     */
    protected function loadCoreAndStandardHelpers()
    {
        static $coreHelpersLoaded = 0;

        if ($coreHelpersLoaded) {
            return;
        }

        $coreHelpersLoaded = 1;

        $helpers = array_unique(array_merge(array('Helper', 'Url', 'Asset', 'Tag', 'Escaping'), sfConfig::get('sf_standard_helpers')));

        $this->context->getConfiguration()->loadHelpers($helpers);
    }

}
