<?php

/**
 * Description of artWidgetHelper
 *
 
 */
class artWidgetHelper
{

    /**
     *
     */
    public static function loadHelpers()
    {
        BaseForm::getContext()->getConfiguration()->loadHelpers(array('I18N', 'Url'));
    }

    /**
     * @param sfWidgetForm $widget
     * @param $value
     * @return sfWidgetForm
     */
    public static function setLabel(sfWidgetForm &$widget, $value)
    {
        if ($widget->getOption('required'))
            $value = sfContext::getInstance()->getI18N()->__($value) . ' <span class="art-required-field">*</span>';

        $widget->setOption('label', $value);

        return $widget;
    }

    /**
     * metoda configure() znajdująca się w klasach z multiselectem
     * @param sfWidgetForm $widget klasa widgetu z multiselectem
     * @param type $options
     * @param type $attributes
     */
    public static function configureMultiselect(sfWidgetForm &$widget, $options, $attributes)
    {
        self::loadHelpers();
        $widget->addOption('jqueryOptions', false);
        artArray::setDefaultIfNotExists($options, 'multiple', false);
        artArray::setDefaultIfNotExists($options, 'jqueryOptions', false);

        $baseOptions = "checkAllText: '" . __('Zaznacz') . "',
                   uncheckAllText: '" . __('Wyczyść') . "',
                   noneSelectedText: '" . __('Wybierz') . "'";

        if ($options['multiple'] == false)
            $baseOptions .= ",selectedList: 1, multiple: false, showHeader: false";
        else
            $baseOptions .= ",selectedText: '" . __('# wybranych') . "'";

        if ($options['jqueryOptions'] !== false)
            $baseOptions .= ',
        ' . $options['jqueryOptions'];

        $widget->addOption('config', "{ $baseOptions }");
    }

    /**
     * metoda render() znajdująca się w klasach z multiselectem
     * @param sfWidgetForm $widget klasa widgetu z multiselectem
     * @param type $parentRender
     * @param type $name
     * @param type $value
     * @param type $attributes
     * @param type $errors
     * @return type
     */
    public static function renderMultiselect(sfWidgetForm &$widget, $parentRender, $name, $value, $attributes, $errors, $withJs = true)
    {
        $id = artArray::getFromArray($attributes, 'id', $widget->generateId($name));

        $class = $widget->getOption('multiple') ? 'multi' : 'single';

        $render = '<span class="multiselect-container multiselect-container-' . $class . '">
                  <span class="multiselect-left"></span>
                  <span class="multiselect-center">' . $parentRender . '</span>
                    <span class="multiselect-right"></span>
               </span>';

        if ($withJs)
            $render .= sprintf(<<<EOF
<script type="text/javascript">
  jQuery(document).ready(function() {
    jQuery("#%s").multiselect(
      %s
   );
 });

</script>
EOF
                , $id, $widget->getOption('config')
            );

        return $render;
    }

    /**
     * metoda do generowania label podczas robienia $form->render() lub echo form
     * @param sfWidgetFormSchemaFormatter $formatter
     * @param type $name
     * @param type $attributes
     * @return type
     */
    public static function generateLabelInSchemaFormatter(sfWidgetFormSchemaFormatter $formatter, $name, $attributes = array())
    {
        $labelName = $formatter->generateLabelName($name);
        $widgetSchema = $formatter->getWidgetSchema();

        if (false === $labelName)
            return '';

        if (!isset($attributes['for'])) {
            $widgetId = $widgetSchema->generateId($widgetSchema->generateName($name));
            $attributes['for'] = $widgetId;
            $attributes['class'] = $widgetId;

            if ($widgetSchema->getField($name) instanceof sfArtWidgetFormJqueryMultiselectInterface)
                $attributes['class'] .= ' multiselect-label';
        }

        return $widgetSchema->renderContentTag('label', $labelName, $attributes);
    }

    /**
     * @param sfWidgetForm $widget
     * @param $options
     * @param $attributes
     */
    public static function configureSelectNumber(sfWidgetForm &$widget, $options, $attributes)
    {
        $widget->addOption('min', 0);
        $widget->addOption('max', 10);
        $widget->addOption('with_empty', false);
        $widget->addOption('without_choices', array());

        if (isset($options['min']))
            $min = $options['min'];
        if (isset($options['max']))
            $max = $options['max'];

        if ($min > $max)
            $range = range($max, $min);
        else if ($min == $max)
            $range = range($min, $max + 1);
        else
            $range = range($min, $max);

        if (isset($options['with_empty']) && $options['with_empty'])
            $range = array_merge(array(''), $range);

        $choices = array_combine($range, $range);

        if (isset($options['without_choices']))
            foreach ($options['without_choices'] as $number)
                unset($choices[$number]);

        $widget->setOption('choices', $choices);
        $widget->addOption('multiple', false);
        $widget->addOption('expanded', false);
        $widget->addOption('renderer_class', false);
        $widget->addOption('renderer_options', array());
        $widget->addOption('renderer', false);
    }

}
