<?php

/**
 * Description of artBoostrapWidgetFormCheckbox
 *
 
 */
class artBoostrapWidgetFormCheckbox extends sfWidgetFormInputCheckbox {

  /**
   * @param array $options
   * @param array $attributes
   */
  public function __construct($options = array(), $attributes = array()) {
    $this->addOption('is_checked', false);
    
    $attributes['type'] = 'checkbox';
    parent::__construct($options, $attributes);
  }

  /**
   * @param array $options
   * @param array $attributes
   */
  protected function configure($options = array(), $attributes = array()) {
    parent::configure($options, $attributes);

    $this->setOption('value_attribute_value', 1);
  }

  /**
   * @param string $name
   * @param null $value
   * @param array $attributes
   * @param array $errors
   * @return string
   */
  public function render($name, $value = null, $attributes = array(), $errors = array()) {
    if ($this->getOption('is_checked')) {
      $attributes['checked'] = 'checked';
    }

    $checkbox = content_tag('label', parent::render($name, $value, $attributes), array('class' => 'checkbox-inline'));
    return $checkbox;
  }

}
