<?php

class flatyWidgetFormInputDate extends sfWidgetForm
{

    protected function configure($options = array(), $attributes = array())
    {
        $this->addOption('culture', BaseForm::getContext()->getUser()->getCulture());
        $this->addOption('date_format', 'dd/mm/yyyy');
        $this->addOption('time_format', 'hh:mm');
        $this->addOption('with_seconds', false);
        $this->addOption('step_hour', 1);
        $this->addOption('step_minute', 1);
        $this->addOption('step_second', 1);
        $this->addOption('hour_min', false);
        $this->addOption('hour_max', false);
        $this->addOption('number_of_months', 1);
        $this->addOption('min_date', false);
        $this->addOption('max_date', false);

        parent::configure($options, $attributes);
    }

    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $id = $this->generateId($name);
        $valueDateFormat = "d-m-Y";

        $js = $this->getJavascript($id, $valueDateFormat);

        $attributes = array_merge(
            array(
                'class' => isset($attributes['class']) ? $attributes['class'] . ' hasDatetimepicker' : 'hasDatetimepicker',
                'type' => 'text',
                'size' => strlen($valueDateFormat) + 3,
                'id' => $id,
                'name' => $name,
                'value' => (is_null($value) || $value == '') ? '' : date($valueDateFormat, strtotime($value)),
            ), $attributes);

        return $this->renderTag('input', $attributes).$js;
    }

    public function getJavascript($id, &$valueDateFormat)
    {
        $js = "
        <script type=\"text/javascript\">
          $(function() {
            $('#".$id."').parent().addClass('pr');
            $('#".$id."').datepicker({format: 'dd-mm-yyyy'});
          })
        </script>";

        return $js;
    }
}