<?php
/**
 *
 */
class sfArtWidgetFilterDate extends sfWidgetFormDateRange
{
    /**
     * @param array $options
     * @param array $attributes
     */
    protected function configure($options = array(), $attributes = array())
    {
        parent::configure($options, $attributes);

        $this->addOption('with_empty', true);
        $this->addOption('template', 'from %from_date%<br />to %to_date%');
        $this->addOption('filter_template', '%date_range%');
    }

    /**
     * @param string $name
     * @param null $value
     * @param array $attributes
     * @param array $errors
     * @return string
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        $values = array_merge(array('is_empty' => ''), is_array($value) ? $value : array());

        return strtr($this->getOption('filter_template'), array(
            '%date_range%' => parent::render($name, $value, $attributes, $errors),
        ));
    }

    /**
     * @param Doctrine_Query $query
     * @param $field
     * @param $values
     * @return Doctrine_Query
     */
    public static function addDateQuery(Doctrine_Query $query, $field, $values)
    {
        $date_from = '';
        $date_to = '';
        $rootAlias = $query->getRootAlias();

        foreach ($values as $key => $value) {
            if ($key == "from" && strlen($value) >= 10)
                $date_from = $value;
            else if ($key == "to" && strlen($value) >= 10)
                $date_to = substr($value, 0, 10);
        }

        $question = '';
        if (!empty($date_from) && !empty($date_to))
            $question = $rootAlias . '.date BETWEEN ' . "'" . $date_from . "' AND '" . $date_to . "'";
        else if (empty($date_from) && !empty($date_to))
            $question = $rootAlias . ".date <= '" . $date_to . "'";
        else if (!empty($date_from) && empty($date_to))
            $question = $rootAlias . ".date >= '" . $date_from . "'";
        $question = '(' . $question . ')';
        return $query->andWhere($question);
    }

}
