<?php
/**
 * Description of sfArtWidgetFormCheckboxRightLabel
 *
 
 */
class sfArtWidgetFormCheckboxRightLabel extends sfWidgetFormInputCheckbox
{
    /**
     * @param array $options
     * @param array $attributes
     */
    public function __construct($options = array(), $attributes = array())
    {
        $this->addOption('right_label');
        $this->addOption('is_checked', false);

        parent::__construct($options, $attributes);
    }

    /**
     * @param array $options
     * @param array $attributes
     */
    protected function configure($options = array(), $attributes = array())
    {
        parent::configure($options, $attributes);

        $this->setOption('right_label', '');
        $this->setOption('label', false);
    }

    /**
     * @param string $name
     * @param null $value
     * @param array $attributes
     * @param array $errors
     * @return string
     */
    public function render($name, $value = null, $attributes = array(), $errors = array())
    {
        if ($this->getOption('is_checked'))
            $attributes['checked'] = 'checked';

        if ($value == 0)
            $value = null;

        $checkbox = '&nbsp;<label>' . parent::render($name, $value, $attributes, $errors) . ' ' . sfContext::getInstance()->getI18N()->__($this->getOption('right_label')) . '</label>';

        if ($this->getOption('is_hidden'))
            return '<div style="display:none">' . $checkbox . '</div>';
        else
            return $checkbox;
    }
}
